/**
 *  @author ravindra.merawat
 */
Ext.define('Academia.view.importutility.ImportByModule.ImportXMLTimeTableList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.importxmltimetablelist',
	store : 'importutility.ImportXMLTimeTable',
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'importutility.ImportTimeTable',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('IMPORT_DATA'),
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('IMPORT_DATA'),
		glyph: ICONGLYPH.ADDGLYPH,
		hidden:true
	},{
		xtype: 'button',
		text: getCommonTranslation('DOWNLOAD_TEMPLATE'),
		itemId: 'btnDownloadTemp',
		tooltip: getCommonTranslation('DOWNLOAD_TEMPLATE'),
		glyph: ICONGLYPH.ADDGLYPH,
		hidden:true
	},{
		xtype: 'button',
		text: getProgramandcourseTranslation('REFRESH'),
		itemId: 'btnRefresh',
		tooltip: 'Refresh',
		glyph: ICONGLYPH.FORMATGLYPH,
		handler: function(){
			var myGridStore = this.ownerCt.ownerCt.getStore();
			myGridStore.reload();
		}
	},{
		xtype: 'button',
		text: getCommonTranslation('IMPORT_UTILITY_FORCE_RUN'),
		itemId: 'btnForce',
		tooltip: 'Force run job',
		glyph: ICONGLYPH.FORMATGLYPH
	}],
	columns: [{
		header : getCommonTranslation('UPLOADED_FILE_NAME'),
		dataIndex : 'updatedFileName',
		flex : 1,
		renderer:function(value){
			if(value){
				return  '<a href="#">'+value+'</a>';
			}
		}	
	},{
		header : getCommonTranslation('UPLOADED_BY'),
		dataIndex : 'uploadedBy',
		flex : 1,
		renderer:function(obj){
			if(obj.value){
				return  obj.value;
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'importedOn',
		flex : 1,
		renderer: function(val){
			var mergedDate = dateRender(val)+' '+timeRender(val);
			return mergedDate;
		}
	},{
		header : getCommonTranslation('PROCESSING_STATUS'),
		dataIndex : 'status',
		flex : 1
	},{
		header : getCommonTranslation('PROCESSED_ON'),
		dataIndex : 'processedOn',
		flex : 1,
		renderer: function(val){
			var mergedDate = dateRender(val)+' '+timeRender(val);
			return mergedDate;
		}
	}/*,{
	        	 header : getCommonTranslation('FAILURE_FILE'),
		     	 dataIndex : 'whetherRecordFail',
		     	 flex : 1,
		     	 renderer:function(value){
		     		 if(value){
					    return  '<a href="#">'+getCommonTranslation('DOWNLOAD')+'</a>';
		     		 }
		     	 }
	         }*/,{
	        	 header : getCommonTranslation('IMPORT_LOG_FILE'),
	        	 dataIndex : 'whetherRecordFail',
	        	 flex : 1,
	        	 renderer:function(value){
	        		 if(value){
	        			 return  '<a href="#">'+getCommonTranslation('DOWNLOAD')+'</a>';
	        		 }
	        	 }
	         }]
});
