/**
 * @author Deepak Mathur
 */
Ext.define('Academia.view.leavemanagement.approvalsetup.LMApplyForLeaveForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.lmapplyforleaveform',
    method: 'POST',
    //modal: true,
    width: '100%',
    plugins: "formlabelrequired",
    autoScroll: false,
        items: [{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'lmLeaveTypeId',
                itemId: 'lmLeaveTypeId',
                displayField: 'leaveType',
                valueField: 'id',
                store:'leavemanagement.leaveapprovalsetup.LMLeaveTypeStore',
                forceSelection: true,
                editable: false,
                allowBlank: false,
                typeAhead: true,
                fieldLabel: getCommonTranslation('LEAVE_TYPE'),
            },{
                xtype: 'datefield',
                name: 'lmRequestDateId',
                itemId: 'lmRequestDateId',
                style: {
                    'margin-left': '100px !important'
                },
//                vtype: 'daterange',
                editable: false,
              //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
                fieldLabel: getPersonModuleTranslation('REQUEST_DATE'),
                listeners: {
                    render: function(obj) {
                        obj = dateFormatRender(obj);
                        obj.setValue(new Date());
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            itemId:'leaveCounterFieldContainerItemId',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'  
            },
            items: [{
                xtype: 'datefield',
                name: 'lmFromDateId',
                itemId: 'lmFromDateId',
                vtype: 'daterange',
                editable: false,
                allowBlank: false,
            //  minValue: new Date();
                fieldLabel: getPersonModuleTranslation('FROM_DATE'),
                listeners: {
                    render: function(field) {
                      return dateFormatRender(field);
                      
                	
                    }
                },
              //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,       
            	endDateField: 'lmToDateId',
            	//vtype: 'daterange',
            },{
				xtype: 'textfield',
				name: 'leaveCounter',
				itemId:'leaveCounter',
				readOnly: true,
				width: 74,
				fieldStyle:'font-weight:bold;text-align:center;margin-left:8.5px;margin-top:28px;', 
				allowBlank: false,
			},
			{
				xtype: 'displayfield',
				name: 'leaveCounter5',
				itemId:'leaveCounter5',
				readOnly: true,
				width: 70,
				fieldStyle:'margin-left: -48px;',
			
				allowBlank: false,
				style: {
                    'margin-top': '70px !important' 
                },
			},{
                xtype: 'datefield',
                name: 'lmToDateId',
                itemId: 'lmToDateId',
                editable: false,
                allowBlank: false,
                fieldLabel: getPersonModuleTranslation('To_Date'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                },
                 style: {
                    'margin-left': '-60px !important'
                },
            	//startDateField: 'lmFromDateId',
            	//vtype: 'daterange',
            }, {/*
            	xtype: 'checkboxfield',
            	width: 'auto',
            	labelAlign: 'right',
            	itemId:'isHalfDayEnd',
            	boxLabel: 'Half Day',
            	name: 'isHalfDayEnd',
            	width: 100,
            	margin :'28px 0 0 0',
            	disabled:true,
            	inputValue : true,
            	uncheckedValue: false*/
            }]
        },{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'datefield',
                name: 'lmClaimDateId',
                itemId: 'lmClaimDateItemId',
                vtype: 'daterange',
                hidden: true,
                editable: false,
                allowBlank: false,
                maxValue: new Date(),
                fieldLabel: getPersonModuleTranslation('CLAIM_DATE'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                }
            },{
                xtype: 'datefield',
                name: 'lmLeaveRequireOnDateId',
                itemId: 'lmLeaveRequireOnDateItemId',
                style: {
                    'margin-left': '100px !important'
                },
                vtype: 'daterange',
                disabled: true,
                hidden: true,
                editable: false,
                allowBlank: false,
                fieldLabel: getPersonModuleTranslation('LEAVE_REQUIRE_ON_DATE'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                }
            }]
        },{
            xtype: 'fieldcontainer',
            defaults: {
                width: 460,
                labelAlign: 'top'
            },
            items: [{
            xtype: 'radiogroup',
			hidden:true,
			itemId: 'leaveCategory',
			style: {
                    'margin-left': '100px !important'
                },  
            items: [{
                boxLabel: getCommonTranslation('FULL_DAY'),
                name: 'isSelf',
                inputValue: 'fd',
                checked: true,
            }, {
                boxLabel: getCommonTranslation('FIRST_HALF'),
                name: 'isSelf',
                itemId: 'FirstHalfId',
                inputValue: 'fh',
            }, {
                boxLabel: getCommonTranslation('SECOND_HALF'),
                name: 'isSelf',
                itemId: 'SecondHalfId',
                inputValue: 'sh',
            }]         
         }]
        },{
        	xtype: 'fieldcontainer',
        	layout: {
        		type: 'hbox'
        	},
        	defaults: {
        		width: 460,
        		labelAlign: 'top'    
        	},                                      
        	items: [{
        		xtype: 'radiogroup',
        		hidden:true,
        		itemId: 'leaveCategory2',
        		items: [{
        			boxLabel: getCommonTranslation('FIRST_HALF'),
        			name: 'firstRadioGroup',
        			inputValue: false,
        			checked: true

        		}, {
        			boxLabel: getCommonTranslation('SECOND_HALF'),
        			name: 'firstRadioGroup',
        			itemId: 'FirstHalfId',
        			inputValue: true,
        		}]  
        	},
        	    
        	{
				xtype: 'displayfield',
				name: 'leaveCounter2',
				itemId:'leaveCounter2',
				readOnly: true,
				width: 70,
				fieldStyle:'margin-left: -190px;',
			
				allowBlank: false,
				/*style: {
                    'margin-left': '-200px !important' 
                }, */
			},
        	
        	
        	
        	
        	
        	
        	
        	
        	
        	
        	
        	
        		
        		{
        		xtype: 'radiogroup',
        		hidden:true,
        		itemId: 'leaveCategory3',
        		style: {
        			'margin-left': '-210px !important'
        		},
        		items: [{
        			boxLabel: getCommonTranslation('FIRST_HALF'),
        			name: 'secondRadioGroup',
        			inputValue: true,
        		}, {
        			boxLabel: getCommonTranslation('SECOND_HALF'),
        			name: 'secondRadioGroup',
        			itemId: 'FirstHalfId',
        			inputValue: false,
        			checked: true,
        		}]  
        	}],
        },
        
         
        
        {
        	xtype: 'displayfield',
        	id: 'leaveCounter',
        	itemId: 'leaveCounter1',
        	name: 'leaveCounter1',
        	// fieldStyle:'margin-top: -300px;',
        	fieldStyle:'font-weight:bold;',
        	style: {
        		'margin-left': '200px !important'
        	},
        },{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 460,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'textarea',
                name: 'leaveReasonId',
                itemId: 'leaveReasonId',
                width: 460,
                maxLength: 225,
               allowBlank: false,
                fieldLabel: getPersonModuleTranslation('LMAS_LEAVE_REASON_REMARK')
            }]
        }, {
            xtype: 'fieldcontainer', 
            layout: {
                type: 'hbox'
            },
            defaults: {
                //width: 460,
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'multiselectcombofield',
                name: 'employeeNames',
                itemId: 'employeeNames',
                fieldLabel: getPersonModuleTranslation('LMAS_WORK_HANDED_OVER_TO'),
                store:'leavemanagement.leaveapprovalsetup.LMEmployeeSmartSearchExceptRequesterUserStore',
                valueField: 'value',
                displayField: 'value',
                enableKeyEvents: 'true',
                forceSelection: true,
                typeAhead: true,
                hideTrigger: false,
                queryParam: 'codeOrName',
                minChars: 3,
                enableKeyEvents: 'true',
                cls:'multiBrandCampusCls',
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.width = picker.up('combobox').getSize().width;
                        }
                    },
                }
            },{
                xtype: 'filefield',
                itemId: 'uploadFileField',
                region: 'south',
                ui: 'CustomBtnSubmit',
                fieldLabel: getPersonModuleTranslation('SELECT_FILE'),
                buttonText: getPersonModuleTranslation('UPLOAD'),
                name: 'file'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            items: [{
                xtype: 'button',
                itemId: 'applyLeaveBtn',
                text: getCommonTranslation('SUBMIT'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('RESET'),
                itemId: 'applyLeaveResetBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    
});