/**
 * @author Deepak Mathur
 */
Ext.define('Academia.view.leavemanagement.approvalsetup.LMApprovalConfigreSetupGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.lmapprovalconfigresetupgrid',
    store: 'leavemanagement.leaveapprovalsetup.LMConfigurationSetupGridStore',
    title: getPersonModuleTranslation('LMAS_APPROVAL_FLOW_CONFIGURATION'),
    border: true,
    autoScroll: false,
    frame: false,
   // width: '100%',
    selType:'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
        showHeaderCheckbox: true,
        checkOnly: true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
        allowDeselect: false,
        //injectCheckbox:1
    },
   dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'leavemanagement.leaveapprovalsetup.LMConfigurationSetupGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
       // grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
   /* tbar: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        cls: 'windowBtnPos',
        defaults: {
            labelAlign: 'top',
        },
        items: [{
            xtype: 'button',
            text: getPersonModuleTranslation('LMAS_VIEW_CONFIGURE'),
            itemId: 'viewConfigureBtnId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            tooltip: getPersonModuleTranslation('LMAS_VIEW_CONFIGURE'),
        }]
    }],*/
    columns: [{
        header: getPersonModuleTranslation('EMPLOYEE_ID'),
        dataIndex: 'employeeCode',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('NAME'),
        dataIndex: 'employeeName',
        flex: 1,
        sortable: true,
    },/* {
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocName',
        flex: 1,
        sortable: true,
    },*/ {
        header: getPersonModuleTranslation('DEPARTMENT'),
        dataIndex: 'department',
        flex: 1,
        sortable: true,
        renderer: function(value) {
        	if(!isNullOrEmpty(value)){ 
        		return value;
        	}else{
        		return "-";	
        	}            
        }
    }, {
        header: getPersonModuleTranslation('LMAS_GROUP_NAME'),
        dataIndex: 'groupName',
        flex: 1,
        sortable: true,
    }, {
        header: getCommonTranslation('USER_TYPE'),
        dataIndex: 'usertype',
        flex: 1,
        sortable: true,
        renderer: function(value) {
        	if(!isNullOrEmpty(value)){ 
        		return value;
        	}else{
        		return "-";	
        	}            
        }
    }, {
        header: getPersonModuleTranslation('DESIGNATION'),
        dataIndex: 'designation',
        flex: 1,
        sortable: true,
        renderer: function(value) {
        	if(!isNullOrEmpty(value)){ 
        		return value;
        	}else{
        		return "-";	
        	}            
        }
    }, {
        header: getPersonModuleTranslation('LMAS_JOINING_DATE'),
        dataIndex: 'joiningDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
        	if(!isNullOrEmpty(date)){ 
        		return dateRender(date);
        	}else{
        		return "-";	
        	} 
        }        
    }, {
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'configurationstatus',
        flex: 1,
        sortable: true,
    }]
});