/**
 * @author Deepak Mathur
 */
Ext.define('Academia.view.leavemanagement.approvalsetup.LMEmployeePastLeaveRequestDetailForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.lmemployeepastleaverequestdetailform',
    method: 'POST',
    //modal: true,
    //width: '100%',
    height:'100%',
    plugins: "formlabelrequired",
    autoScroll: false,
        items: [{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'textfield',
                name: 'lmLeaveTypeId',
                itemId: 'lmLeaveTypeId',
                allowBlank: false,
                readOnly:true,
                fieldLabel: getCommonTranslation('LEAVE_TYPE'),
            }, {
                xtype: 'datefield',
                name: 'lmRequestDateId',
                itemId: 'lmRequestDateId',
                style: {
                    'margin-left': '100px !important'
                },
                vtype: 'daterange',
                readOnly:true,
                editable: false,
              //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
                fieldLabel: getPersonModuleTranslation('REQUEST_DATE'),
                listeners: {
                    render: function(obj) {
                        obj = dateFormatRender(obj);
                        obj.setValue(new Date());
                    }
                }
            }]
        },{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'datefield',
                name: 'lmCancelFromDateId',
                itemId: 'lmCancelFromDateId',
                editable: false,
                readOnly:true,
                hidden: true,
                fieldLabel: getPersonModuleTranslation('LM_LEAVE_CANCELLED_FROM_DATE'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                },
                endDateField : 'lmCancelToDateId',
                vtype : 'daterange'
            }, { 
				xtype: 'tbspacer', 
				width: 100 
			},{
                xtype: 'datefield',
                name: 'lmCancelToDateId',
                itemId: 'lmCancelToDateId',
                editable: false,
                readOnly:true,
                hidden: true,
                fieldLabel: getPersonModuleTranslation('LM_LEAVE_CANCELLED_TO_DATE'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                },
                startDateField : 'lmCancelFromDateId',
                vtype : 'daterange'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'datefield',
                name: 'lmFromDateId',
                itemId: 'lmFromDateId',
                vtype: 'daterange',
                editable: false,
                allowBlank: false,
                readOnly:true,
                fieldLabel: getPersonModuleTranslation('FROM_DATE'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                },
              //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            	endDateField: 'lmToDateId',
            	vtype: 'daterange'
            }, {
            	xtype: 'checkboxfield',
            	width: 'auto',
            	labelAlign: 'right',
            	itemId:'isHalfDayStart',
            	boxLabel: 'Half Day',
            	name: 'isHalfDayStart',
            	width: 100,
            	margin :'28px 0 0 0',
            	inputValue : true,
            	readOnly:true,
            	uncheckedValue: false
            	}, 
            {
                xtype: 'datefield',
                name: 'lmToDateId',
                itemId: 'lmToDateId',
                vtype: 'daterange',
                editable: false,
                allowBlank: false,
                readOnly:true,
                fieldLabel: getPersonModuleTranslation('To_Date'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                },
              //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            	startDateField: 'lmFromDateId',
            	vtype: 'daterange'
            }, {
            	xtype: 'checkboxfield',
            	width: 'auto',
            	labelAlign: 'right',
            	itemId:'isHalfDayEnd',
            	boxLabel: 'Half Day',
            	name: 'isHalfDayEnd',
            	width: 100,
            	margin :'28px 0 0 0',
            	disabled:true,
            	inputValue : true,
            	readOnly:true,
            	uncheckedValue: false
            }]
        },{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'datefield',
                name: 'lmClaimDateId',
                itemId: 'lmClaimDateItemId',
                vtype: 'daterange',
                hidden: true,
                editable: false,
                allowBlank: false,
                readOnly:true,
                maxValue: new Date(),
                fieldLabel: getPersonModuleTranslation('CLAIM_DATE'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                }
            },{
                xtype: 'datefield',
                name: 'lmLeaveRequireOnDateId',
                itemId: 'lmLeaveRequireOnDateItemId',
                style: {
                    'margin-left': '100px !important'
                },
                vtype: 'daterange',
                hidden: true,
                editable: false,
                allowBlank: false,
                readOnly:true,
                fieldLabel: getPersonModuleTranslation('LEAVE_REQUIRE_ON_DATE'),
                listeners: {
                    render: function(field) {
                        return dateFormatRender(field);
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 460,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'textarea',
                name: 'leaveReasonId',
                itemId: 'leaveReasonId',
                width: 460,
                maxLength: 250,
                readOnly:true,
                fieldLabel: getPersonModuleTranslation('LMAS_LEAVE_REASON_REMARK')
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                //width: 460,
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'multiselectcombofield',
                name: 'employeeNames',
                itemId: 'employeeNames',
                fieldLabel: getPersonModuleTranslation('LMAS_WORK_HANDED_OVER_TO'),
                //disabled:true,
               // allowBlank: false,
               // store:'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
                store:'leavemanagement.leaveapprovalsetup.LMEmployeeSmartSearchExceptRequesterUserStore',
                valueField: 'id',
                displayField: 'value',
                editable:false,
        		cls:'multiBrandCampusCls',
                enableKeyEvents: 'true',
                forceSelection: true,
                typeAhead: true,
                hideTrigger: false,
                queryParam: 'codeOrName',
                minChars: 3,
                readOnly:true,
                enableKeyEvents: 'true',
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.width = picker.up('combobox').getSize().width;
                        }
                    },
                }
            },{
                xtype: 'textfield',
                name: 'lmDocumentName',
                itemId: 'lmDocumentNameItemId',
                readOnly:true,
                fieldLabel: getPersonModuleTranslation('SELECT_FILE'),
            }]
        }]
});