/**
 * @author Deepak Mathur
 */
Ext.define('Academia.view.leavemanagement.approvalsetup.LMLeaveBalanceAndApprovalFlowGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.lmleavebalanceandapprovalflowgrid',
	store: 'leavemanagement.leaveapprovalsetup.LMLeaveBalanceAndApprovalGridStore',
	title: getPersonModuleTranslation('LMAS_Leave_Detail'),
	border: true,
	frame: false,
	// selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	/*selModel: {
        showHeaderCheckbox: true,
        checkOnly: true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
        allowDeselect: false,
        //injectCheckbox:1
    },*/
	/*dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'leavemanagement.leaveapprovalsetup.LMLeaveBalanceAndApprovalGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],*/
	initComponent: function() {
		var grid = this;
		// grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		cls: 'windowBtnPos',
		defaults: {
			labelAlign: 'top',
		},
		/* items: [{
             xtype: 'button',
             text: getPersonModuleTranslation('LMAS_VIEW_CONFIGURE'),
             itemId: 'viewConfigureBtnId',
             ui: 'CustomBtnSubmit',
             scale: CONSTANTS.BUTTONSIZE,
             tooltip: getPersonModuleTranslation('LMAS_VIEW_CONFIGURE'),
         }]*/
	}],
	columns: [{
		header: getPersonModuleTranslation('LMAS_START_DATE'),
		dataIndex: 'lcsStartDate',
		flex: 1,
		sortable: true,
	},{
		header: getPersonModuleTranslation('LMAS_LEAVE_TYPE'),
		dataIndex: 'hrLeaveTypeIDCode',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			return value.value;
		}
	}, {
		header: getPersonModuleTranslation('LMAS_ENTITLED'),
		dataIndex: 'entitled',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				return Ext.util.Format.number(value, '0.00');
			} else {
				return "-";
			}
		}
	}, {
		header: getPersonModuleTranslation('LMAS_APPLIED'),
		dataIndex: 'applied',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				return Ext.util.Format.number(value, '0.00');
			} else {
				return "-";
			}
		}
	}, {
		header: getPersonModuleTranslation('LMAS_APPROVED'),
		dataIndex: 'approved',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				return Ext.util.Format.number(value, '0.00');
			} else {
				return "-";
			}
		}
	}, {
		header: getPersonModuleTranslation('LMAS_AVAILED'),
		dataIndex: 'availed',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				return value;
			} else {
				return "-";
			}
		}
	}, {
		header: getPersonModuleTranslation('LMAS_BALANCE'),
		dataIndex: 'balance',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				return Ext.util.Format.number(value, '0.00');
			} else {
				return "-";
			}
		}
	}]
});