/**
 * @author Ankur Jaiswal
 */
Ext.define('Academia.view.leavemanagement.report.LMEmployeeLeaveSLAReportGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.lmemployeeleaveslareportgrid',
    store: 'leavemanagement.report.LMEmployeeLeaveSLAReportGridStore',
    title: getPersonModuleTranslation('LM_LEAVE_REQUESTS'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'leavemanagement.report.LMEmployeeLeaveSLAReportGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [],
    columns: [{
        header: getPersonModuleTranslation('LM_REQUESTER_ID'),
        dataIndex: 'requesterId',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('NAME'),
        dataIndex: 'requesterName',
        flex: 1,
        sortable: true,
    }, {
    	header: getPersonModuleTranslation('REQUEST_DATE'),
    	dataIndex: 'requestDate',
    	flex: 1,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
    	header: getPersonModuleTranslation('FROM_DATE'),
    	dataIndex: 'fromDate',
    	flex: 1,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
    	header: getPersonModuleTranslation('To_Date'),
    	dataIndex: 'toDate',
    	flex: 1,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    },{
        header: getCommonTranslation('LEAVE_TYPE'),
        dataIndex: 'leaveType',
        flex: 1
    },{
    	header : getPersonModuleTranslation('LM_RESPONDED_ON'),
        dataIndex: 'respondedOn',
		flex:1,
		renderer:function(respondedOn) {
    		if(!isNullOrEmpty(respondedOn) ) {
    			return dateRender(respondedOn);
    		} else {
    			return respondedOn;
    		}
    	}
	},{
		header : getPersonModuleTranslation('LM_CLOSED_ON'),
        dataIndex: 'closedOn',
		flex:1,
		renderer:function(closedOn) {
    		if(!isNullOrEmpty(closedOn) ) {
    			return dateRender(closedOn);
    		}
    		return closedOn;
    	}
	}, {
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'status',
        flex: 1
    },{
    	header : getPersonModuleTranslation('LM_TURN_AROUND_TIME'),
        dataIndex: 'turnAroundTime',
		flex:1
	},{
		header : getPersonModuleTranslation('LM_SLA_STATUS'),
        dataIndex: 'slaStatus',
		flex:1
	}, {
        header: getCommonTranslation('LM_SLA_TIMELINE'),
        dataIndex: 'view',
        flex: 1,
        renderer: function(value, metadata, record) {
    		var msg = '<a href="#">' + "View" + '</a>';
    		return msg;
    	}
    }],
});