/**
 * @author Varsha Gour
 */
Ext.define('Academia.view.leavemanagement.report.LMLeaveApprovalFlowReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.lmleaveapprovalflowreportgrid',
	store: 'leavemanagement.report.LMLevaeApprovalReportSerachStore',
	title: getServiceRequestTranslation('LEAVE_APPROVAL_FLOW_REPORT'),
	border: true,
	frame: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},  
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'leavemanagement.report.LMLevaeApprovalReportSerachStore',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo: true
		}]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar: [],
	columns: [{
		header: getPersonModuleTranslation('EMPLOYEE_ID'),
		dataIndex: 'code',
		flex: 1,
		sortable: true
	},/* {
        header: getProgramandcourseTranslation('ACADEMY_LOCATIONS'),
        dataIndex: 'academyLocationId',
        flex: 1,
        sortable: true
    },*/ {
		header: getPersonModuleTranslation('NAME'),
		dataIndex: 'staffPrintName',
		flex: 1,
		sortable: true
	}, {
		header: getPersonModuleTranslation('DESIGNATION'),
		dataIndex: 'designation',
		flex: 1,
		sortable: true
	}, {
		header: getPersonModuleTranslation('DEPARTMENT'),
		dataIndex: 'department',
		flex: 1,
		sortable: true
	}, {
		header: getPersonModuleTranslation('LMAS_LEAVE_TYPE'),
		dataIndex: 'approverType',
		flex: 1,
		sortable: true,
		renderer:function(value,meta,record){
			if(value == "SEQUENTIAL"){
				return "Sequential";
			}else if(value == "PARALLEL"){
				return "Parallel";
			}else if(value == "AUTO_APPROVE"){
				return "Auto Approve";
			}else{
				return value;
			}
		} 
	}, {
		header: getPersonModuleTranslation('LEVEL1_APPROVER'),
		dataIndex: 'approver1',
		flex: 1,
		sortable: true
	}, {
		header: getPersonModuleTranslation('LEVEL2_APPROVER'),
		dataIndex: 'approver2',
		flex: 1,
		sortable: true
	}, {
		header: getPersonModuleTranslation('LEVEL3_APPROVER'),
		dataIndex: 'approver3',
		flex: 1,
		sortable: true
	}, {
		header: getPersonModuleTranslation('LEVEL4_APPROVER'),
		dataIndex: 'approver4',
		flex: 1,
		sortable: true
	}, {
		header: getPersonModuleTranslation('LAST_UPDATED_ON'),
		dataIndex: 'lastUpdate',
		flex: 1,
		sortable: true,
		renderer: function(lastUpdate) {
			if(!isNullOrEmpty(lastUpdate)) {
				return dateRender(lastUpdate);
			}
			return lastUpdate;
		}
	}, {
		header: getPersonModuleTranslation('LAST_UPDATED_BY'),
		dataIndex: 'lastUpdatedByPN',
		flex: 1,
		sortable: true
	}],
});