/**
 * @author Soham.Gurjar
 */
Ext.define('Academia.view.lecturerCostingDefinition.LecturerCostingCourseFilter', {   
	extend : 'Academia.view.common.IdGeneratorCustomForm',
	alias : 'widget.lecturercostingcoursefilter',
	plugins : "formlabelrequired",
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
			items :[{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTerm',
				itemId : 'academicTerm',
				displayField : 'value',
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				valueField : 'id',
				typeAhead : true,
				editable : true,
				queryMode:'local',
             	forceSelection : true,
             	anyMatch : true,
             	allowBlank:false
			},{
				xtype: 'multiselectcombofield',
				fieldLabel: getCommonTranslation('LECTURER'),
				itemId: 'lecturerId',
				name: 'lecturer',
				valueField:'id',
				autoloadStore: false,
				displayField:'value',
				store:Ext.create('Academia.store.common.MappedFacultyStore'),
				allowBlank:true,
				disabled:true,
				typeAhead:true,
				height:30,
				queryParam:'name',
    			minChars:3,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				//cls:'ProgramCourseMultiselectField resetPasswordMultiselect',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				forceSelection:true,
    			  listConfig: {
    				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
    				  },
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
    	            }
			}]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'multiselectcombofield',
						fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
						itemId: 'courseCodeId',
						name: 'COURSE_ID',
						valueField:'id',
						displayField:'coursecodeName',
						store:Ext.create('Academia.store.lecturercostingdefinition.LCDCourseStore'),
						allowBlank:true,
						disabled:true,
						width:460,
						queryParam:'name',
		    			minChars:3,
						typeAhead:true,
						_isStoreLoadCalled:true,
						triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
						enableKeyEvents  : 'true',
						hideTrigger:false,
					//	cls:'ProgramCourseMultiselectField resetPasswordMultiselect',
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						forceSelection:true,
		    			  listConfig: {
		    				  listeners: {
		  						beforeshow: function(picker) {
		  							picker.minWidth = picker.up('combobox').getSize().width;
		  						}
		      				  },
		    	                loadingText: getCommonTranslation('SEARCHING'),
		    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    	                getInnerTpl: function() {
		    	                    return '<div class="search-item">' +
		    	                        '{courseCode} / {courseName}'+ 
		    	                    '</div>';
		    	                }
		    	            }
					},{
						xtype: 'multiselectcombofield',
						fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
						name:'COURSE_VARIENT_ID',
						itemId: 'courseVariantId',
					    store:'lecturercostingdefinition.LCDCourseVariantStore',
						displayField: 'value',
						valueField: 'id',
						typeAhead:true,
						queryParam:'name',
		    			minChars:3,
						width:460,
						allowBlank:true,
						disabled:true,
						_isStoreLoadCalled:true,
						triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
						enableKeyEvents  : 'true',
						hideTrigger:false,
						//cls:'ProgramCourseMultiselectField resetPasswordMultiselect',
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						forceSelection:true,
		    			  listConfig: {
		    				  listeners: {
		  						beforeshow: function(picker) {
		  							picker.minWidth = picker.up('combobox').getSize().width;
		  						}
		      				  },
		    	                loadingText: getCommonTranslation('SEARCHING'),
		    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    	                getInnerTpl: function() {
									return '<div class="search-item">' +
									'{value}' +
									'</div>';
								}
		    	            },
		    	            listeners:{
					            expand: function(combo) {
					                // Ensure the picker is shown even if the store is already loaded
					                combo.ignoreSelection = 0;
					            }
							}
					}]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'multiselectcombofield',
						name: 'programWiseProgram',
						width:460,
						itemId: 'programWiseProgramId',
						fieldLabel: getProgramandcourseTranslation('PROGRAM_BATCH'),
						store: Ext.create('Academia.store.lecturercostingdefinition.LCDProgramBatchPeriodStore'),
						displayField:'valueCode',
						valueField:'id',
						queryParam:'programName',
						typeAhead : true,
						forceSelection:true,
						disabled:true,
						hideTrigger:false,
						triggerAction: 'all',
						minChars:3,
						autoloadStore:false,
						cls:'ProgramCourseMultiselectField',
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}'  +
								'</div>';
							}
						}
					},
					{
						xtype: 'multiselectcombofield',
						name: 'programWisePeriod',
						itemId:'programWisePeriodId',
						fieldLabel: getCourseTxCommonTranslation('PERIOD'),
						store: Ext.create('Academia.store.lecturercostingdefinition.LCDProgramBatchPeriodStore'),
						valueField: 'id',
						displayField: 'value',
						typeAhead : true,
						forceSelection:true,
						hideTrigger:false,
						triggerAction: 'all',
						minChars:3,
						width:460,
						disabled:true,
						queryParam:'programName',
						autoloadStore:false,
						cls:'ProgramCourseMultiselectField',
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}'  +
								'</div>';
							}
						}
					}]
				},{
		            xtype: 'fieldcontainer',
		            width: 'auto',
		            style:{
                    	marginTop:'10px'
	                    },
		            items: [{
		                xtype: 'button',
		                text: getCommonTranslation('SEARCH'),
		                itemId: 'lecturerCostingSearchBtn',
		                buttonAlign: 'left',
		                formBind:true,
		                ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE
		            },{
		                xtype: 'button',
		                text: getCourseTxCommonTranslation('RESET'),
		                itemId: 'resetButton',
		                buttonAlign: 'left',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
		        }]
    	//}]
});