/**
 * Abhishek Chouhan
 */
var manageMarksModerationGridStore = Ext.create('Academia.store.manageMarksModeration.ManageMarksModerationGridStore');
Ext.define('Academia.view.manageMarksModeration.ManageMarksModerationGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.managemarksmoderationgrid',
	store: manageMarksModerationGridStore,
	border: true,
	frame: false,
	removeSerialColumn: true, // V2D-469625
	selType: 'checkboxmodel',
	title: getExaminationTranslation('MANAGE_MARKS_MODERATION'),
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		checkOnly: true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
		allowDeselect: false,
		//injectCheckbox:1
	},
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			itemId: 'managePaggingToolBarItemId',
			plugins: ['pagesize'],
			store: manageMarksModerationGridStore,
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo: true
		}]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}, {
		xtype: 'button',
		itemId: 'applyChangesBtn',
		scale: CONSTANTS.BUTTONSIZE,
		text: getExaminationTranslation('APPLY_CHANGES'),
		tooltip: getExaminationTranslation('APPLY_CHANGES')
	},
	{
		xtype: 'button',
		itemId: 'editMarks',
		scale: CONSTANTS.BUTTONSIZE,
		text: getExaminationTranslation('EDIT'),
		tooltip: getExaminationTranslation('EDIT'),
		disabled: true
	},
	{
		xtype: 'button',
		itemId: 'saveMarks',
		scale: CONSTANTS.BUTTONSIZE,
		text: getExaminationTranslation('SAVE'),
		tooltip: getExaminationTranslation('SAVE'),
		disabled: true

	}],
	columns: [{
		header: getExaminationTranslation('S_NO'),
		xtype: 'rownumberer',
		sortable: true,
		align: 'center',
		flex: .2,
		dataIndex: 'rownumberer'
	}, {
		header: getExaminationTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex: .4,
		sortable: true
	}, {
		header: getExaminationTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex: .4,
		sortable: true
	}, {
		header: getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex: .3,
		sortable: true
	}, {
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex: .3,
		sortable: true
	}, {
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex: .3,
		sortable: true
	}, {
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex: .3,
		sortable: true
	}, {
		header: getExaminationTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex: .3,
		hidden: true,
		sortable: true
	}, {
		header: getExaminationTranslation('COURSE'),
		dataIndex: 'courseName',
		flex: .3,
		sortable: true
	}, {
		header: getExaminationTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantCode',
		flex: .3,
		hidden: true,
		sortable: true
	}, {
		header: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
		dataIndex: 'assessmentSchemeLevel',
		flex: .3,
		sortable: true
	}, {
		header: getExaminationTranslation('LEVEL_NAME'),
		dataIndex: 'levelName',
		flex: .3,
		sortable: true
	}, {
		header: getExaminationTranslation('OBTAINED_MARKS'),
		dataIndex: 'effectiveMarks',
		flex: .3,
		sortable: true
	}, {
		header: getExaminationTranslation('MODERATION_MARKS'),
		dataIndex: 'moderationPoints',
		flex: .3,
		sortable: true
	}, {
		header: getExaminationTranslation('MODERATION_EFFECTIVE_MARKS'),
		dataIndex: 'effectedModerationPoints',
		flex: .3,
		sortable: true,
		editor: {
			xtype: 'numberfield',
			minValue: 0
		},
		renderer: function(value, meta, record) {

			//   meta.tdCls ="gridInputCustomStyleForCell"


			if (value != null) {
				if (record.data.isEdit) {
					var intModerationMark = parseFloat(value);
					var intEffectiveMarks;
					if (record.get('effectiveMarks') != null) {
						intEffectiveMarks = parseFloat(record.get('effectiveMarks'));
					}
					else {
						intEffectiveMarks = 0;
					}
					var moderationValue = Math.round((intModerationMark - intEffectiveMarks) * 100) / 100;
					setTimeout(function() {
						record.set('moderationPoints', moderationValue);
					}, 100);
					return intModerationMark;
				} else {
					return value;

				}
			} else {
				if (record.data.isEdit) {
					meta.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				} else {
					return value;
				}
			}
		}
	}, {
		header: getExaminationTranslation('MIN_MARKS'),
		dataIndex: 'minMarks',
		flex: .3,
		hidden: true,
		sortable: true
	}, {
		header: getExaminationTranslation('MAX_MARKS'),
		dataIndex: 'maxMarks',
		flex: .3,
		hidden: true,
		sortable: true
	}, {
		header: getCommonTranslation('REASON'),
		dataIndex: 'moderationReason',
		flex: .8,
		sortable: true,
		editor: {
			xtype: 'customcombobox',
			name: 'remarkValue',
			itemId: 'remarkValueItemId',
			store: Ext.create('Academia.store.examinationcenters.remark.MarkModerationReasonStore'),
			valueField: 'value',
			displayField: 'value',
			editable: true,
			maxLength: 255,

			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				getInnerTpl: function(displayField) {
					return '<tpl if="xindex%2==0"><div class="oddColorCombo" style="width:404px"></tpl><tpl if="xindex%2==1"><div class="evenColorCombo" style="width:404px"></tpl> {' + displayField + '} </div>';
				}
			}
		},
		renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
			rec.tdCls = "gridInputCustomStyleForCell";
			if (isNullOrEmpty(val)) {
				if (record.data.isEdit) {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			} else {
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
				rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
				rec.tdCls = "assign-remark-column-cls";
				return val;
			}
		}
	}],
	plugins: {
		ptype: 'cellediting',
		clicksToEdit: 1
	},
	listeners: {
		beforeedit: function(editor, context) {
			if ((editor.context.field == 'effectedModerationPoints' || editor.context.field == 'moderationReason') && context.record.data.isEdit) {
				if (editor.context.field == 'effectedModerationPoints') {
					context.view.getGridColumns()[13].getEditor().setMaxValue(context.record.data.maxMarks)
				}
				return true

			} else {
				return false
			}
		}
	}
});