/**
 * @author Amit G
 */
Ext.define('Academia.view.managetarget.ActualAppointmentsTargetPadmsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.actualappointmentstargetpadmsgrid',
    store: 'managetarget.ActualAppointmentsTargetDetailPadmsGridStore',
    title: getAdmissionTranslation('ACTUAL_APPOINTMENTS_TARGETS'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    dockedItems : [{
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    		xtype: 'custompagingtoolbar',
    		plugins:['pagesize'],
    		store : 'managetarget.ActualAppointmentsTargetDetailPadmsGridStore',
    		emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
    		displayInfo : true
    	} ]
    }],
    columns: [{
        header: getCommonTranslation('ENQUIRY_ID'),
        dataIndex: 'enquiryCode',
        flex: 0.5,
        sortable: true,
        renderer : function(value){
        	if( !isNullOrEmpty(value) && value != 0 ){
        		return  '<a href="#">'+value+'</a>';
        	} else {
        		return  value;
        	}
		}
    },{
        header: getCommonTranslation('APPLICATION_ID'),
        dataIndex: 'applicationCode',
        flex: 0.5,
        sortable: true,
        renderer : function(value){
        	if( !isNullOrEmpty(value) && value != 0 ){
        		return  '<a href="#">'+value+'</a>';
        	} else {
        		return  value;
        	}
		}
    }, {
        header: getAdmissionTranslation('TARGET_ENQUIRER_NAME'),
        dataIndex: 'enquirerName',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
        		return value;
        	}
        }
    }, {
        header: getAdmissionTranslation('APPOINTMENT_DATE'),
        dataIndex: 'appointmentDate',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
				return dateRender(value);
        	}
        }
    },{
        header: getAdmissionTranslation('PERSON_TO_MEET'),
        dataIndex: 'personToMeet',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
				return value;
        	}
        }
    }]
});
