/**
 * @author Amit G
 */
Ext.define('Academia.view.managetarget.ActualEnquiryTargetPadmsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.actualenquirytargetpadmsgrid',
    store: 'managetarget.ActualEnquiryTargetDetailPadmsGridStore',
    title: getAdmissionTranslation('ACTUAL_ENQUIRY_TARGETS'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    dockedItems : [{
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    		xtype: 'custompagingtoolbar',
    		plugins:['pagesize'],
    		store : 'managetarget.ActualEnquiryTargetDetailPadmsGridStore',
    		emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
    		displayInfo : true
    	} ]
    }],
    columns: [{
        header: getCommonTranslation('ENQUIRY_ID'),
        dataIndex: 'enquiryCode',
        flex: 0.5,
        sortable: true,
        renderer : function(value){
        	if( !isNullOrEmpty(value) && value != 0 ){
        		return  '<a href="#">'+value+'</a>';
        	} else {
        		return  value;
        	}
		}
    }, {
        header: getAdmissionTranslation('TARGET_ENQUIRER_NAME'),
        dataIndex: 'enquirerName',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
        		return value;
        	}
        }
    }, {
        header: getCommonTranslation('ENQUIRY_DATE'),
        dataIndex: 'enquiryDate',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
					return dateRender(value);
			}
        }
    }, {
        header: getAdmissionTranslation('TOTAL_ACTUAL_ENQUIRY_OWNER'),
        dataIndex: 'enquiryOwnerShortName',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
				return value;
        	}
        }
    }]
});
