/**
 * @author Amit G
 */
Ext.define('Academia.view.managetarget.ActualPresentationsTargetPadmsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.actualpresentationstargetpadmsgrid',
    store: 'managetarget.ActualPresentationLeadTargetPadmsGridStore',
    title: getAdmissionTranslation('ACTUAL_PRESENTATIONS_TARGETS'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    dockedItems : [ {
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    		xtype: 'custompagingtoolbar',
    		plugins:['pagesize'],
    		store : 'managetarget.ActualPresentationLeadTargetPadmsGridStore',
    		emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
    		displayInfo : true
    	} ]
    }],
    columns: [{
        header: getCommonTranslation('CAMPAIGN_NAME'),
        dataIndex: 'campaignNewName',
        flex: 0.5,
        sortable: true,
        renderer : function(value){
        	if( !isNullOrEmpty(value) && value != 0 ){
        		return  '<a href="#">'+value+'</a>';
        	} else {
        		return  value;
        	}
		}
    }, {
        header: getCommonTranslation('CAMPAIGN_TYPE'),
        dataIndex: 'campaignTypeValue',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
        		return value;
        	}
        }
    }, {
        header: getAdmissionTranslation('PRESENTATIONS_DATE'),
        dataIndex: 'campaignNewStartDate',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
					return dateRender(value);
			}
        }
    }, {
        header: getCommonTranslation('OWNER'),
        dataIndex: 'campaignNewOwnerShortName',
        flex: 0.5,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value)) {
				return value;
        	}
        }
    }]
});
