/**
 * @author Gajendra Verma
 */
Ext.define('Academia.view.managetarget.ManageTargetByAdmissionsOfferGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.managetargetbyadmissionsoffergrid',
    store: 'managetarget.ManageTargetByStafAdmissionsOfferStore',
    title: getAdmissionTranslation('ADMISSION_OFFER_TARGETS'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
        headerFix: true,
        portalIdsWithStructure: {
            'managetargetbystafftabstructure':1
        }
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academyName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('LOCATION'),
        dataIndex: 'locationName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('INTAKE_YEAR'),
        dataIndex: 'intakeYearName',
        flex: 1,
        sortable: true,
    },{
		header:  getCommonTranslation('MODE_OF_DELIVERY'),
		dataIndex: 'modeOfDeliveryValue',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('REGISTRATION_TYPE'),
		dataIndex: 'registrationType',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				if(value==true){
					return getCommonTranslation("PART_TIME");	
				}else {
					return getCommonTranslation("FULL_TIME");	
				}
				
			}
		}
	}, {
        header: getAdmissionTranslation('TOTAL_ADMISSIONS_OFFER_TARGET'),
        dataIndex: 'actualTarget',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('TOTAL_ACTUAL_ADMISSIONS_OFFER'),
        dataIndex: 'actualTargetAchived',
        flex: 1,
        sortable: true,
        renderer : function(value){
        	if( !isNullOrEmpty(value) && value != 0 ){
        		return  '<a href="#">'+value+'</a>';
        	} else {
        		return  value;
        	}
		}
    }, {
        header: getAdmissionTranslation('PERCENTAGE_TO_ADMISSIONS_OFFER_TARGET'),
        dataIndex: 'percentageTargetAchieved',
        flex: 1,
        sortable: true,
        renderer : function(value){
        	if(!isNullOrEmpty(value)){
        		if(value == 0 || value == 0.00){
        			return  '0.00 %';
        		}else{
        			return  value +' %';
        		}
        		
        	} 
		}
    }, {
        header: getAdmissionTranslation('TOTAL_VARIANCE'),
        dataIndex: 'targetVariance',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('STAFF_DETAILS'),
        dataIndex: 'staffCount',
        flex: 1,
        sortable: true,
        renderer : function(value){
           	if( !isNullOrEmpty(value) && value != 0 ){
           	return  '<a href="#">'+value+'</a>';
           	} else {
           	return  '<a href="#">'+"Add"+'</a>';
           	}
    }
    }]
});
