/**
 * @author Amit G
 */
Ext.define('Academia.view.managetarget.PresentationLeadDetailsManageTargetGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.presentationleaddetailsmanagetargetgrid',
    store: 'managetarget.ManageTargetPresentationLeadDetailsStore',
    title: getAdmissionTranslation('PRESENTATION_LEAD_DETAILS'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    columns: [{
        header: getAdmissionTranslation('SALES_STAFF'),
        dataIndex: 'staffCode',
        flex: 1,
        sortable: true
    },{
        header: getAdmissionTranslation('PRESENTATION_NAME'),
        dataIndex: 'campaignNewName',
        flex: 1,
        sortable: true,
    }, {
        header: getAdmissionTranslation('PRESENTATION_LEAD_TARGET'),
        dataIndex: 'actualTarget',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'numberfield',
            name: 'presentationLeadTarget',
            itemId: 'presentationLeadTargetItemId',
            maxLength: 6,
            enforceMaxLength: true,
            hideTrigger: true,
            keyNavEnabled: false,
            mouseWheelEnabled: false,
            allowExponential: false,
            allowDecimals: false,
            listeners: {
        		change: function(obj, record){
        			var grid = obj.up('grid')
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			var SalesSPT = obj.getValue();
        			var actualTargetAchived = selectedRecord.data.actualTargetAchived;
        			if(!isNullOrEmpty(actualTargetAchived) && !isNullOrEmpty(SalesSPT)){
        				if(actualTargetAchived==0 || SalesSPT==0){
        					var targetPercentage=0;
        				}else{
        					var targetPercentage = (actualTargetAchived/SalesSPT)*100;	
        				}
        				var targetVariance = actualTargetAchived - SalesSPT; 
        			}
        			if(!isNullOrEmpty(selectedRecord.data.id)){
    					var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

    				}else{
    					var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
    				}
        			recordToBeUpdated.set('percentageTargetAchieved',targetPercentage);
        			recordToBeUpdated.set('targetVariance',targetVariance);
        		}
        	}
        },
        renderer : function(value,meta,rec){
        	var isActualTargetReadOnly = rec.data.isActualTargetReadOnly;
        	if( !isNullOrEmpty(isActualTargetReadOnly) && isActualTargetReadOnly == true ){
        		if( !isNullOrEmpty(rec.data.actualTarget) ){
        			return rec.data.actualTarget;
        		}else if( !isNullOrEmpty(rec.data.numberOfleadsTargeted) ){
        			return rec.data.numberOfleadsTargeted;
        		}
        	} else {
        		if (isNullOrEmpty(value)) {
        			meta.tdCls = 'gridInputCustomStyle';
                    return getExaminationTranslation('CLICK_TO_ENTER');
                } else {
                    return value;
                }
        	}
        }
    }, {
        header: getAdmissionTranslation('PRESENTATION_LEAD_ACTUAL'),
        //dataIndex: 'presentationLeadActual',
        dataIndex: 'actualTargetAchived',
        flex: 1,
        sortable: true,
    }, {
        header: getAdmissionTranslation('SALES_STAFF_PERCENTAGE_TO_LEAD_TARGET'),
        //dataIndex: 'salesStaffPercentage',
        dataIndex: 'percentageTargetAchieved',
        flex: 1.2,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					
					return Ext.util.Format.number(value, "0.00")+' %';
				}
				catch(e){
					return null;
				}
			}
        }
    }, {
        header: getAdmissionTranslation('SALES_STAFF_VARIANCE'),
        //dataIndex: 'applicationTarget',
        dataIndex: 'targetVariance',
        flex: 1,
        sortable: true,
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        }
    }],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    },
    listeners: {
        beforeedit: function(editor, context) {
        	if(editor.context.field == "actualTarget"){
        		var editor = context.grid.columns[2].getEditor();
        		var selectedRecord = context.record;
                var isActualTargetReadOnly = selectedRecord.data.isActualTargetReadOnly;
            	if( !isNullOrEmpty(isActualTargetReadOnly) && isActualTargetReadOnly == true ){
            		try{
            			editor.setReadOnly(true);
            		} catch(err){
            		}
            		return context.colIdx !== 2;
            	} else {
            		try{
            			editor.setReadOnly(false);
            		} catch(err){
            		}
            	}
        	}
        }
    }
    /*plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(obj, editor, context) {
            	if(editor.field == "actualTarget"){
            		var grid = editor.grid;
            		var selectedRecord = editor.record;
                    
                    var textField = editor.column.field;
                    var isActualTargetReadOnly = selectedRecord.data.isActualTargetReadOnly;
                	if( !isNullOrEmpty(isActualTargetReadOnly) && isActualTargetReadOnly == true ){
                		try{
                			editor.setReadOnly(true);
                		} catch(err){
                			textField.setReadOnly(true);
                		}
                	} else {
                		try{
                			editor.setReadOnly(false);
                		} catch(err){
                			textField.setReadOnly(false);
                		}
                	}
            	}
            }
        }
    }]*/
});
