/**
 *  @author Ramkrishna Yadav
 */

Ext.define('Academia.view.mangeElections.candidate.EmployeeVoterPoolGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.employeevoterpoolgrid',
	store : 'election.election.ElectionStaffVoterPoolGridStore',
	border: true,
	autoScroll: false,
	selType:'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'election.election.ElectionStaffVoterPoolGridStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'captureBollotVotesBtn',
		tooltip: getCommonTranslation('CAPTURE_BALLOT_VOTES'),
		text: getCommonTranslation('CAPTURE_BALLOT_VOTES'),
	},{
		xtype: 'button',
		itemId: 'sendMessageBtn',
		tooltip: getCommonTranslation('SEND_MESSAGE'),
		 text: getCommonTranslation('SEND_MESSAGE'),
		
			},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		 text: getCommonTranslation('DELETE'),
		//glyph: ICONGLYPH.DELETEGLYPH
	},{
		 xtype:'textfield',
		 emptyText: getCommonTranslation('ENTER_THREE_CHAR_BY_STAFF_ID_NAME'),
		 width: 300,
		 name:'empVoterPoolGridSearch',
		 itemId:'empVoterPoolGridSearch',
		 cls: 'SearchTextFieldWithSmallHeader'
	},'->',{
		xtype: 'button',
		itemId: 'changeWeightage',
		tooltip: getCommonTranslation('CHANGE_WEIGHTAGE'),
		 text: getCommonTranslation('CHANGE_WEIGHTAGE'),
		
			}],
	columns: [{
		header : getCommonTranslation('EMPLOYEE_ID'),
		dataIndex : 'employeeId',
		flex:1,
		renderer: function(value, metadata, record) {
	         
            return '<a href="#">' + value + '</a>';
        }
	},{
		header : getCommonTranslation('NAME'),
		dataIndex : 'name',
		flex:1,
		
	},{
		header :getCommonTranslation('EMAIL_ID'),
		dataIndex : 'emailId',
		flex:1
	},{
		header :getCommonTranslation('VOTING_STATUS'),
		dataIndex : 'votingAction',
		flex:1,
        renderer:function(value) {
        	if(!isNullOrEmpty(value)){
        		var val;
    			if(value == 'VOTED') {
    				val = '<span  style="color:Green;">' +getCommonTranslation("VOTED")+ '</span>';
    			}else if(value == 'NOT_VOTED') {
    				val = '<a href="#" style="color:red;">' +getCommonTranslation("NOT_VOTED")+ '</a>';
    			}else{
    				val = value;
    			}
    			return val;
        	}else{
        		return '-';
        	}
		}
	},{
		header :getCommonTranslation('VOTE_WEIGHTAGE'),
		dataIndex : 'weightage',
		flex:1
	}]
});