/**
 * @author prathamesh.sheth
 *  
 * This component is used for to Show list of email IDs,Mobile Phones for Adhoc Recepients.
 *   
 */	   
Ext.define('Academia.view.messaging.AdhocRecepientWindow',
{
		extend : 'Ext.window.Window',
		alias : 'widget.adhocrecepientwindow',			
		modal : true,		
		autoScroll:true,
		resizable:false,
		height:(Ext.isIE8)?600:'65%',
		width:(Ext.isIE8)?500:'50%',
		title:getMessagingModuleTranslation('ADHOC_RECEPIENT'),		
		items : [{
				 xtype: 'form',				         
		         itemId: 'adhocRecepientform',		         
		         plugins: "formlabelrequired",    
		         items: [{
		        	 xtype:'hidden',
		        	 name:'emailDBId',
		        	 itemId:'emailDBId'
		         },{
		        	 xtype:'hidden',
		        	 name:'mobileDBId',
		        	 itemId:'mobileDBId'
		         },{
		             xtype: 'fieldcontainer',		             		             
		             style:{
		             	marginLeft: '15px'
		             },
		             items: [{
		                 xtype: 'textarea',
		                 fieldLabel: getMessagingModuleTranslation('EMAIL_IDS'),
		                 name: 'emailIds',
		                 itemId: 'emailIds',
		                 labelAlign:'top',
		                 maxLength : 60000,
		                 heigth:500,
		                 width:'100%',
		                 vtype:'multiemail',
//		                 allowBlank: false,
		                 listeners: {
		                     blur: function(textarea) {
		                    	 var value = textarea.getValue().trim();
		                    	 if(isNullOrEmpty(value)){
		                    		 Ext.QuickTips.register({
			                             target: textarea.getEl()
			                         }); 
		                    	 }
		                         
		                     }
		                 }
		             }]
		         },{
		             xtype: 'fieldcontainer',		             		             
		             style:{
		             	marginLeft: '15px'
		             },
		             items: [{
		                 xtype: 'textarea',
		                 fieldLabel: getMessagingModuleTranslation('MOBILE_NOS'),
		                 name: 'mobileNos',
		                 itemId: 'mobileNos',
		                 labelAlign:'top',
		                 heigth:500,
		                 width:'100%',
		                 maxLength : 60000,
//		                 allowBlank: false,
		                 validator: function(value){
		                	 if(!isNullOrEmpty(value.trim())){
		                		 var validText = getMessagingModuleTranslation('VALIDATOR_COMMA_SEPARATED_MSG');
			                	 var patt = new RegExp('^([0-9]{10})+(,[0-9]{10})*$');
			                	 var res = patt.test(value.trim());
			                     if(res) {
			                         return true;
			                     } else {
			                         return validText;
			                     }
		                	 }else{
		                		 return true;
		                	 }
		                     
		                 },
		                 listeners: {
		                     blur: function(textarea) {
		                    	 textarea.setValue(textarea.getValue().trim());
		                     }
		                 }
		             }]
		         },{
	                 xtype: 'text',
	                 aligh:'right',
	                 style: {            
			             marginLeft: '15px'
			         },
	                 text: getMessagingModuleTranslation('VALUE_COMMA_SEPERATED')
	             },{
		             xtype: 'fieldcontainer',
		         	 width:'100%',		
  		         	 style: {            
		                marginLeft: '15px',
		                marginTop: '25px'
		             },
		             items: [{
		                 xtype: 'button',
		                 text: getCommonTranslation('SAVE'),
		                 itemId: 'adhocRecepientSaveBtn',		                 
		                 ui: 'CustomBtnSubmit',
		                 scale: CONSTANTS.BUTTONSIZE,
		                 formBind: true
		             }, {
		                 xtype: 'button',
		                 text: getCommonTranslation('CANCEL'),
		                 ui: 'CustomBtnCancel',
		                 itemId: 'adhocRecepientCancelBtn',
		                 scale: CONSTANTS.BUTTONSIZE
		             }]
		         }]
		}]
});
