/**
 * @author prathamesh.sheth
 * 
 * This is the Template approve/reject/resubmit form panel.   
 *   
 * 
 */
Ext.define('Academia.view.messaging.TemplateApproveRejectFormPanel',{
	extend:'Ext.form.Panel',
	alias:'widget.templateapproverejectformpanel',
	autoScroll:false,
	frame: true,	
	plugins : "formlabelrequired",	
	items:[{
            xtype: 'fieldcontainer',
            layout: 'vbox',        
            width:'100%',
            items: [{
                xtype: 'textareafield',
                name: 'reviewComment',
                itemId:'reviewCommentTxtArea',
                //emptyText: getMessagingModuleTranslation('REVIEW_REMARK'),
                maxLength: 500,
                hidden:true,
                disabled:true,
                width:'50%',
                allowBlank: false,
                listeners: {
                	blur: function(field, newValue, oldValue, eOpts){
                		field.setValue(field.getValue().trim());
                	}
                }
            }]
    	},{
            xtype: 'fieldcontainer',
            layout: {
        		type: 'hbox'
        	}, 
        	items: [{
                xtype: 'button',
                itemId: 'btnApproveReviewComment',                   
                text:getMessagingModuleTranslation('APPROVE'), //Approve
                ui: 'CustomBtnSubmit',
                hidden:true,
                disabled:true,
                status:CONSTANTS.MSG_TEMP_APPROVED,  //APPROVED                
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                itemId: 'btnRejectReviewComment',                    
                text:getMessagingModuleTranslation('REJECT'), //Reject
                ui: 'CustomBtnSubmit',
                hidden:true,
                disabled:true,
                status:CONSTANTS.MSG_TEMP_REJECTED,  //REJECTED
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                itemId: 'btnReSubmitForApprovalComment',                    
                text:getMessagingModuleTranslation('RESUBMIT_FOR_APPROVAL'), //ReSubmit for Approval
                ui: 'CustomBtnSubmit',
                hidden:true,
                disabled:true,
                status:CONSTANTS.MSG_TEMP_RESUBMIT_FOR_APPROVAL,  //RESUBMIT_FOR_APPROVAL
                scale: CONSTANTS.BUTTONSIZE
            }]
    	}]
});