/**
 * 
 * This component is used for to show Address Details Dialog Box 
 */

Ext.define('Academia.view.organization.addresses.AddressFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.addressFormWindow',
    modal: true,
    maxHeight:600,
	autoScroll:true,
    title: getCommonTranslation('ADDRESS_DETAILS'),
    margin: 0,
    items: [{
        xtype: 'form',
        margin: 0,
        bodyPadding: '10 10 10 10',
        standardSubmit: false,
        plugins : "formlabelrequired",
        items: [{
            xtype: 'addressfieldsform',
            itemId:'addressfieldsform'
        },  {
        	xtype:'fieldcontainer',
        	width:'100%',
        	cls:'windowBtnPos',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'saveButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind : true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel', // edited by Guruling
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE

            }]
        }]
    }, {
        xtype: 'hidden',
        name: 'addressCategory',
        value: 'ORG'
    }],
 // BEGIN SCROLL-SAVING WORKAROUND CODE    
    onRender : function() {
        this.callParent(arguments);
        this.body.on('scroll', this.saveScroll, this);
    },
    
    afterComponentLayout : function() {
        this.callParent(arguments);
        this.restoreScroll();
    },
    
    saveScroll : function() {
        this.savedScroll = this.body.getScroll();
    },
    
    restoreScroll : function() {
        var savedScroll = this.savedScroll || {};  // empty obj for when no scroll has occurred before this method is executed
        this.body.scrollTo('top', savedScroll.top || 0);
    }
    // END SCROLL-SAVING WORKAROUND CODE
});