/*
 * File for the grid of ALP to children from supervision, SA and MA Tabs.
 */
Ext.define('Academia.view.organization.supervision.ALPToChildGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.alptochildgrid',
    title: getCommonTranslation('ALPTOCHILDTITLE'),
    store: 'organization.ALPToChildren',
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
	    header: getCommonTranslation('PARENTSASAUMAU'),
	    dataIndex: 'parentOrganizationUnit',
	    flex: 0.2
	},{
	    header: getCommonTranslation('CHILDSASAUMAU'),
	    dataIndex: 'organizationUnit',
	    flex: 0.2
	},{
	    header: getCommonTranslation('ACADEMY'),
	    dataIndex: 'academy.academyName',
	    flex: 0.2
	},{
	    header: getCommonTranslation('LOCATION'),
	    dataIndex: 'location.name',
	    flex: 0.1
	}, {
	    header: getCommonTranslation('PURPOSE'),
	    dataIndex: 'purpose',
	    flex: 0.1
	}, {
	    header: getCommonTranslation('OWNER'),
	    dataIndex: 'owner',
	    flex: 0.1
	},{
	    header: getCommonTranslation('END_DATE'),
	    dataIndex: 'tillDate',
	    xtype: 'datecolumn',
	    dateFormat: 'd-m-Y',
	    flex: 0.1,
		renderer:function(date) {
			return dateRender(date);
		}
	}],
	dockedItems: [{
		xtype: 'custompagingtoolbar',
        plugins:['pagesize'],
	    dock: 'bottom',
	    displayInfo: true,
	    store: 'organization.ALPToChildren'
	}]
});