/**
 * @author trupti.paoneker
 * 
 * This component is used for to show window with new bank master details. 
 */
Ext.define('Academia.view.othermasters.bankmaster.BankMasterFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.bankmasterformwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('BANK_MASTER_DETAILS'),
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'bankMasterForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'bankMaster_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'version'
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'nestedJsonCombo',
                fieldLabel: getCommonTranslation('ACADEMY'),
                name: 'academy',
                itemId: 'academyId',
                editable: false,
                labelAlign: 'top',
                store: 'common.AcademyStore',
                displayField: 'value',
                valueField: 'id',
                allowBlank: false
            }, {
                xtype: 'nestedJsonCombo',
                fieldLabel: getCommonTranslation('LOCATION'),
                name: 'location',
                itemId: 'locationId',
                labelAlign: 'top',
                editable: false,
                queryMode:'local',
                store: 'common.AcademyLocationByAcademyId',
                displayField: 'locationName',
                valueField: 'locationId',
                allowBlank: false

            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                fieldLabel: getCommonTranslation('BANK_CODE'),
                xtype: 'textfield',
                itemId: 'bankCode',
                name: 'bankCode',
                labelAlign: 'top',
                maxLength: 20,
                allowBlank: false
            }, {
                fieldLabel: getCommonTranslation('BANK_IFSC_CODE'),
                xtype: 'textfield',
                itemId: 'ifscCode',
                name: 'ifscCode',
                labelAlign: 'top',
                maxLength: 20,
               // minLength: 11,
               // enforceMaxLength: true,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                fieldLabel: getCommonTranslation('BANK_ACC_NO'),
                xtype: 'textfield',
                itemId: 'accountNo',
                name: 'accountNo',
                labelAlign: 'top',
                maxLength: 30,
                allowBlank: false
            }, {
                fieldLabel: getCommonTranslation('BANK_NAME'),
                xtype: 'textfield',
                itemId: 'bankName',
                name: 'bankName',
                labelAlign: 'top',
                maxLength: 30,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                fieldLabel: getCommonTranslation('BRANCH_NAME'),
                xtype: 'textfield',
                itemId: 'branchName',
                name: 'branchName',
                labelAlign: 'top',
                maxLength: 30,
                allowBlank: false
            }, {
                xtype: 'statusCombo',
                itemId: 'bankStatus',
                store: Ext.create('Ext.data.Store', {
                    fields : [ 'name','value'],
                    data: [
                           {  name: getCommonTranslation('ACTIVE'), value:'on' },            
                           { name: getCommonTranslation('INACTIVE'), value:'off'}
                    ]
                }),
                allowBlank: false,
                editable : false,
                name: 'bankStatus',
                labelAlign: 'top'
            }/*, {
                fieldLabel: getCommonTranslation('STATUS'),
                xtype: 'checkboxfield',
                itemId: 'bankStatus',
                name: 'bankStatus',
                labelAlign: 'left',
                allowBlank: false

            }*/]
        }

		, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                fieldLabel: getCommonTranslation('MERCHANT_ID'),
                xtype: 'textfield',
                itemId: 'merchantId',
                name: 'merchantId',
                labelAlign: 'top',
                maxLength: 255,
                allowBlank: true
				
            }]
        }
, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 460
            },
            items: [{
                fieldLabel: getCommonTranslation('BRANCH_ADDRESS'),
                xtype: 'textarea',
                itemId: 'branchAddress',
                name: 'branchAddress',
                labelAlign: 'top',
                maxLength: 300,
                allowBlank: false
            }]
        },{
        	xtype: 'fieldcontainer',
    		//fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),
//    	    hidden : true,
//    	    disabled:true, 
    		labelAlign: 'top',
    		layout : {
    			type : 'hbox'
    		},
    		defaults: {
                width: 226
            },
    		items : [{
				xtype: 'checkboxfield',
				itemId : 'defaultBank',
				labelAlign: 'right',
				region: 'south',
				height:45,
				/*style: {
					marginTop: '25px',
					marginLeft:'5px'
				},*/
				boxLabel: getCommonTranslation('DEFAULT_BANK_ACCOUNT'),
				name: 'defaultBank',
				inputValue: true,
				uncheckedValue: false
			},{

				xtype: 'checkboxfield',
				itemId : 'isOnlineBankAccount',
				labelAlign: 'right',
				region: 'south',
				height:45,
				/*style: {
					marginTop: '25px',
					marginLeft:'5px'
				},*/
				boxLabel: getCommonTranslation('ONLINE_BANK_ACCOUNT'),
				name: 'isOnlineBankAccount',
				inputValue: true,
				uncheckedValue: false
			
			}]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',

            items: [{
                xtype: 'button',
                itemId: 'btnSaveBankMasterForm',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelBankMasterForm',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});
