/**
 * @author Trupti.Paoneker
 
 * This component is used for to show certificate master grid details.
 */
Ext.define('Academia.view.othermasters.certificatemaster.CertificateMasterGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.certificatemastergrid',
    store: 'othermasters.certificatemaster.CertificateMasterStore',
    title: getCommonTranslation('CERTIFICATE_MASTER'), //Certificate Master
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [{
        header: getCommonTranslation('CERTIFICATE_TYPE'), //Certificate Type
        dataIndex: 'certificateCategory',
        sortable: false,
        flex: .2,
        renderer: function(value) {
            if (value==='PROGRAM') {
                return getCommonTranslation('PROGRAM');
            } else if(value=='COURSES') {
                return getCommonTranslation('COURSES');
            }else if(value=='COMMUNITY'){
            	return getCommonTranslation('COMMUNITY');
            }else if(value=='OTHER'){
            	return getCommonTranslation('OTHER');
            }else if(value=='HOSTEL_LEAVE'){
            	return getCommonTranslation('HOSTEL_LEAVE');
            }else if(value=='LEAVE'){
            	return getCommonTranslation('LEAVE');
            }else if(value=='VISITOR_PASS'){
            	return getCommonTranslation('VISITOR_PASS');
            }
        }
    },{
        header: getCommonTranslation('CERTIFICATE_CODE'), //Certificate Code	
        dataIndex: 'code',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('CERTIFICATE_NAME'), //Certificate Name
        dataIndex: 'name',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('CERTIFICATE_APPLICABLE_TO'), //Certificate Name
        dataIndex: 'certificateApplicableTo',
        sortable: false,
        flex: .2,
        renderer: function(value) {
            if (value=='FACULTY') {
                return getCommonTranslation('FACULTY');
            } else if(value=='STUDENT') {
                return getCommonTranslation('STUDENT');
            } else if(value=='ALL') {
                return getCommonTranslation('ALL');
            }
        }
    }, {
        header: getCommonTranslation('STATUS'), //Status
        dataIndex: 'isActive',
        sortable: false,
        flex: .2,
        renderer: function(value) {
            if (value) {
                return getCommonTranslation('ACTIVE');
            } else {
                return getCommonTranslation('INACTIVE');
            }
        }


    },{
        header: getCommonTranslation('ROLE'), //Certificate Name
        dataIndex: 'rolesCount',
        sortable: false,
        flex: .2
    }, /* {
        header: getCommonTranslation('VIEW_TEMPLATE'), //View template
        dataIndex: 'id',
        sortable: false,
        flex: .2,
        renderer: function(value) {
            if (!isNullOrEmpty(value)) {
                return '<a href=#>View Template</a>';
            }
        }
    }*/],

    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
        //text : getCommonTranslation('ADD')
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
        //text : getCommonTranslation('EDIT')
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
        //text : getCommonTranslation('VIEW')
    }],

    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'othermasters.certificatemaster.CertificateMasterStore',
            emptyMsg: getCommonTranslation('NO_CERTIFICATE_MASTER_TO_DISPLAY'), //No Certificate master  to display
            displayInfo: true
        }]
    }]
});