/**
 * @author trupti.paoneker
 * 
 * This component is used for to show Currency exchange rate History Details.
 */
Ext.define('Academia.view.othermasters.currencymaster.CurrencyExchangeRateHistoryGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.currencyexchangeratehistorygrid',
    store: 'othermasters.currencymaster.CurrencyExchangeRateHistoryStore',
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'othermasters.currencymaster.CurrencyExchangeRateHistoryStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('DATE'),
        dataIndex: 'applicableDate',
        sortable: false,
        flex: 1,
        renderer: function(value) {
        	return dateRender(value);
         }
    },{
        header: getCommonTranslation('FROM_CURRENCY'),
        dataIndex: 'fromCurrency',
        sortable: false,
        flex: 1,
        renderer: function(val) {
        	if(!isNullOrEmpty(val)){
        		return val.value;
        	}
         }
    }, {
        header: getCommonTranslation('TO_CURRENCY'),
        dataIndex: 'toCurrency',
        sortable: false,
        flex: 1,
        renderer: function(val) {
        	if(!isNullOrEmpty(val)){
        		return val.value;
        	}
         }
        
    }, {
        header: getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
        dataIndex: 'exchangeRate',
        sortable: false,
        flex: 1,
       /* renderer: function(obj) {
            return columnObjRender(obj, 'exchangeRate');
        }*/

    }]
});