/**
 * @author Amit G
 
 * This component is used for to show currency master grid details.
 */
Ext.define('Academia.view.othermasters.currencymaster.CurrencyMasterListSetupGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.currencymasterlistsetupgrid',
    store: 'othermasters.currencymaster.CurrencyMasterMainGridStore',
    title: getCommonTranslation('CURRENCY_LIST'),
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'othermasters.currencymaster.CurrencyMasterMainGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), //Add Currency
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'), //Edit Currency
        glyph: ICONGLYPH.EDITGLYPH
    }],
    columns: [{
        header: getCommonTranslation('CURRENCY_CODE'),
        dataIndex: 'currencyCode',
        sortable: false,
        flex: 1

    }, {
        header: getCommonTranslation('CURRENCY_NAME'),
        dataIndex: 'name',
        sortable: false,
        flex: 1

    },{
        header: getCommonTranslation('STATUS'), //Status
        dataIndex: 'status',
        sortable: false,
        flex: 1,
        renderer: function(obj) {
            if (obj== true) {
                return getCommonTranslation('ACTIVE') ;
            } else if(obj== false) {
                return getCommonTranslation('INACTIVE') ;
            }
        }
    }]
});