/**
 * @author Amit G
 
 * This component is used for to show currency master grid details.
 */
Ext.define('Academia.view.othermasters.currencymaster.ExchangeRateCurrencyMasterGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.exchangeratecurrencymastergrid',
    store: 'othermasters.currencymaster.ExchangeRateCurrencyMasterGridStore',
    title: getCommonTranslation('EXCHANGE_RATE_LIST'),
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'othermasters.currencymaster.ExchangeRateCurrencyMasterGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), //Add Currency
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'), //Edit Currency
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'), //View Currency
        iconCls: 'view-icon'
    }],
    columns: [{
        header: getCommonTranslation('FROM_CURRENCY'),
        dataIndex: 'fromCurrencyName',
        sortable: false,
        flex: 1
    },{
        header: getCommonTranslation('CURRENCY_CODE'),
        dataIndex: 'formCurrencyCode',
        sortable: false,
        flex: 1
    }, {
        header: getCommonTranslation('TO_CURRENCY'),
        dataIndex: 'toCurrencyName',
        sortable: false,
        flex: 1
    }, {
        header: getCommonTranslation('CURRENCY_CODE'),
        dataIndex: 'toCurrencyCode',
        sortable: false,
        flex: 1

    }, {
        header: getCommonTranslation('TODAY_EXCHANGE_RATE'),
        dataIndex: 'exchange',
        sortable: false,
        flex: 1

    },  {
        header: getCommonTranslation('STATUS'), //Status
        dataIndex: 'status',
        sortable: false,
        flex: 1,
        renderer: function(obj) {
            if (obj == true) {
                return getCommonTranslation('ACTIVE') ;
            } else if(obj == false) {
                return getCommonTranslation('INACTIVE') ;
            }
        }
    }, {
        header: getCommonTranslation('DATE_WISE_EXCHANGE_RATE_HISTORY'),
        dataIndex: 'exchangeRateHistory',
        sortable: true,
        //store: 'othermasters.currencymaster.CurrencyExchangeRateHistoryStore',
        flex: 1,
     	renderer : function(value){
			  return  '<a href="#">View</a>';
		}
    }]
});