/**
 * @author Akshay Sharma

 * This component is used for to show School Type master grid details.
 */
Ext.define('Academia.view.othermasters.programGroupMaster.ProgramGroupMasterGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.programgroupmastergrid',
	store: 'othermasters.programGroupMaster.ProgramGroupMasterStore',
	title: getProgramandcourseTranslation('PROGRAM_GROUP_MASTER'), // School Type Master
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
        var grid=this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
	},
	headerFix:{
	    headerFix: true,
	    portalIdsWithStructure: {
	    	'programgroupmasterstructure':1
	    }
    },
	columns: [{
		header: getProgramandcourseTranslation('ACADEMY_LOCATION'), //Brand-Campus
		dataIndex: 'academyLocation',
		sortable: false,
		flex: .2,
		renderer: function(obj) {
			return columnObjRender(obj, 'value');
		}
	}, {
		header: getCommonTranslation('PROGRAM_GROUP_NAME'), //School Type
		dataIndex: 'programGroup',
		sortable: false,
		flex: .2,
		renderer: function(obj) {
			return columnObjRender(obj, 'value');
		}
	}, {
		header: getProgramandcourseTranslation('EMIS_NUMBER'), //EMIS Number
		dataIndex: 'eMISNumber',
		sortable: false,
		flex: .2

	}, {
		header: getProgramandcourseTranslation('EMIS_PROVINCE'), //EMIS Province
		dataIndex: 'eMISProvince',
		sortable: false,
		flex: .2,
		renderer: function(obj) {
			return columnObjRender(obj, 'value');
		}
	}, {
		header: getProgramandcourseTranslation('SCHOOL_TYPE_CODE'),
		dataIndex: 'schoolTypeCode',
		sortable: false,
		flex: .2
	}, {
		header: getProgramandcourseTranslation('BOARDING_SCHOOL'), //Boarding School
		dataIndex: 'isBoardingSchool',
		sortable: false,
		flex: .2,
		renderer:function(value,meta,record){
			if(record.data.isBoardingSchool){
				return "<span style=\'color:green\'>Yes</span>";
			} else {
				return "<span style=\'color:red\'>No</span>";
			}
		}  
	}, {
		header: getProgramandcourseTranslation('PRINCIPAL'),
	    dataIndex: 'principal',
	    sortable: false,
	    flex: .2,
	    renderer: function(principal, meta, record) {
	        if (!isNullOrEmpty(principal) && !isNullOrEmpty(principal.value)) {
	            return principal.value;
	        }
	        return '';
	    } 
	}, {
		header: getProgramandcourseTranslation('LOGO'),
		dataIndex: 'logoPath',
		sortable: false,
		flex: .2,
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				value="<a href='#'>View</a>"; 
				return value;
			}
		},
	},{
		header: getProgramandcourseTranslation('PHYSICAL_ADDRESS'), //physicalAddress
		dataIndex: 'physicalAddress',
		sortable: false,
		flex: .2
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'), //Add Bank
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'), //Edit Bank
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'), //View Bank
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		text: getCommonTranslation('MANAGE_ADDRESS'),
		itemId: 'addProgramGroupAddressItemId' 
	}],
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'othermasters.programGroupMaster.ProgramGroupMasterStore',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'), //No Record to display
			displayInfo: true
		}]
	}]
});