/**
 *  BursaryFunddingDetails Action Grid
 */
Ext.define('Academia.view.personinfo.common.NSFAS.BursaryFunddingDetails', {
	extend: 'Ext.tree.Panel',
	alias: 'widget.bursaryfunddingdetails',
	title: getPersonModuleTranslation('FUNDDING_DETAILS'),
	border: true,
	rootVisible: false,
	cls: 'bursaryfunddingdetails no-tree-icon exclude-tree-panel-style',
	singleExpand: false,
	reserveScrollbar: false,
	height: window.innerHeight-130,
	useArrows: false,
	// disableSelection: true,
	autoScroll: false,
	scroll: 'vertical',
	frame:false,
	rowLines: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	deferRowRender: true,
	tbar: [{
		xtype: 'button',
		itemId: 'checkStatus',
		text: getCommonTranslation('CHECK_STATUS'),
		tooltip : getCommonTranslation('CHECK_STATUS'),
		ui: 'CustomBtnSubmit',
		cls: 'x-btn x-unselectable x-btn-CustomBtnSubmit-small x-noicon x-btn-noicon x-btn-CustomBtnSubmit-small-noicon',
	}],

	columns: [{
		xtype: 'treecolumn',
		text: getCommonTranslation('LM_UPDATED_ON'),
		dataIndex: 'updateOn',
		sortable: false,
		flex: 2,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view) {
            //rec.innerCls = "";
			if(record.isLeaf()){
				rec.innerCls = "";
			}
			if(record.data.isParent) {
				rec.tdCls =  "tdBackgroungCls";	
				rec.innerCls ="hideExpandedIconCls"
			}
			else{
				rec.innerCls ="x-grid-cell-inner-treecolumn cellTextNormalFontCls";
			}
			if(!isNullOrEmpty(val)) {
				return dateRender(val)+' '+timeRender(val);
			}  
            

		}
	},  {
		header: getCommonTranslation('CYCLE'),
		dataIndex: 'cycle',
		sortable: false,
		flex: .5,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view) {
			if(record.data.isParent) {
				rec.tdCls =  "tdBackgroungCls";				
			}
			return val;
		}
		
	}, {
		header: getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'givenName',
		sortable: false,
		flex: .5,
		renderer:function(value, metaData, record) {
			if(record.data.isParent) {
				metaData.tdCls =  "tdBackgroungCls";				
			}
			return value+" "+record.data.surName;
		}
	}, {
		header: getCommonTranslation('NATIONAL_ID'),
		dataIndex: 'identification',
		sortable: false,
		flex: .5,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view) {
			if(record.data.isParent) {
				rec.tdCls =  "tdBackgroungCls";				
			}
			return val;
		}
	}, {
        header: getCommonTranslation('IDENTIFICATION_TYPE'),
        dataIndex: 'identificationType',
        sortable: false,
        flex: .2,
		
    }, {
		header: getCommonTranslation('REFERENCE_NO'),
		dataIndex: 'applicationRefNo',
		sortable: false,
		flex: .4,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view) {
			if(record.data.isParent) {
				rec.tdCls =  "tdBackgroungCls";				
			}
			return val;
		}
	}, {
		header: getCommonTranslation('APPLICANT_INDICATOR'),
		dataIndex: 'isApplicantIndicator',
		sortable: false,
		flex: .4,
		renderer:function(value,rec,record,rowIndex,colIndex,store,view) {
			var isIndicator = 'False';
			if(record.data.isParent) {
				rec.tdCls =  "tdBackgroungCls";				
			}
			if (!isNullOrEmpty(value)) {
				isIndicator = 'True';
			}
			if(record.isLeaf()){
				return "";
			}else{
				return isIndicator;
			}

		}
	}, {
		header: getCommonTranslation('RETURNING_STUDENT'),
		dataIndex: 'isReturningStudentIndicator',
		sortable: false,
		flex: .4,
		renderer:function(value,rec,record,rowIndex,colIndex,store,view) {
			var isIndicator = 'False';
			if(record.data.isParent) {
				rec.tdCls =  "tdBackgroungCls";				
			}
			if (!isNullOrEmpty(value)) {
				isIndicator = 'True';
			}
			if(record.isLeaf()){
				return "";
			}else{
				return isIndicator;
			}
			
		}
	}, {
		header: getCommonTranslation('FUNDDING_YEAR'),
		dataIndex: 'fundingYear',
		sortable: false,
		flex: .4,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view) {
			if(record.data.isParent) {
				rec.tdCls =  "tdBackgroungCls";				
			}
			return val;
		}
	}, {
		header:  getCommonTranslation('FUNDER'),
		dataIndex: 'funder',
		sortable:false,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view) {
			if(record.data.isParent) {
				rec.tdCls =  "tdBackgroungCls";				
			}
			return val;
		}
	},{
		header:  getCommonTranslation('CAP_TYPE'),
		dataIndex: 'capType',
		sortable:false,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view) {

			if(record.isLeaf()){

			}
			else{
				rec.innerCls = "cellTextBoldFontCls";

			}
			if(record.data.isParent) {
				rec.tdCls =  "tdBackgroungCls";	
				rec.innerCls = "cellTextBoldFontCls";
			}
			return val;

		}
	},{
		header:  getCommonTranslation('CURRENCY_CODE'),
		dataIndex: 'currencyCode',
		sortable:false,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view) {
			if(record.data.isParent) {
				rec.tdCls =  "tdBackgroungCls";				
			}
			return val;
		}
	},{
		header:  getCommonTranslation('DECIMAL_PLACES'),
		dataIndex: 'decimalPlace',
		sortable:false,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view) {
			if(record.data.isParent) {
				rec.tdCls =  "tdBackgroungCls";				
			}
			return val;
		}
	},{
		header:  getCommonTranslation('AMOUNT'),
		dataIndex: 'amount',
		sortable:false,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view) {

			if(record.isLeaf()){

			}
			else{
				rec.innerCls = "cellTextBoldFontCls";

			}
			if(record.data.isParent) {
				rec.tdCls =  "tdBackgroungCls";	
				rec.innerCls = "cellTextBoldFontCls";
			}
			return val;

		}
	}],
	store:'personinfo.common.NSFAS.BursaryFunddingDetailStore',
	
});