/**
 * @author Dharmendra.P
 */

Ext.define('Academia.view.personinfo.common.course.DevelopmentPlanGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.developmentplangrid',
    title: getPersonModuleTranslation('DEVELOPMENT_PLAN'),
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
   tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    columns: [{
        header: getPersonModuleTranslation('PROFESSIONAL_GOAL'),
        dataIndex: 'professionalGoal',
        sortable:true,
        flex: .1
    }, {
        header: getPersonModuleTranslation('QUALITIES'),
        dataIndex: 'qualities',
        sortable: true,
        flex: .1
    },  {
        header: getPersonModuleTranslation('STRENGTH'),
        dataIndex: 'strength',
        sortable:true,
        flex: .1
    },{
        header: getPersonModuleTranslation('WEAKNESS'),
        dataIndex: 'weakness',
        sortable:true,
        flex: .1
    },{
        header: getPersonModuleTranslation('OUTCOME'),
        dataIndex: 'expectedOutcome',
        sortable:true,
        flex: .1
    },{
        header: getPersonModuleTranslation('ACHIEVED'),
        dataIndex: 'isAchieved',
        sortable:true,
        flex: .1,
        renderer : function(value) {
        	if (value) {
        		return value = 'Yes';
        	} else {
        		return value = 'No';
        	}
        }
    }],
    
    initComponent: function() {
        var this$ = this;
        //var store = (this$.personType == 'STUDENT')?this$.buildStudentStore():this$.buildFacultyStore();
        var store = this$.buildFacultyStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
   /* buildStudentStore: function() {
        return Ext.create('Academia.store.personinfo.common.course.CourseAttendanceStore');
    },*/
    buildFacultyStore: function() {
        return Ext.create('Academia.store.personinfo.common.course.DevelopmentPlanGridStr');
    }
});