/**
 * @author Dharmendra.P
 */

Ext.define('Academia.view.personinfo.common.course.FacultyCourseInterestGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.facultycourseinterestgrid',
    title: getPersonModuleTranslation('FACULTY_COURSE_INTEREST'),
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    isGridConfigurable: true,
	enableColumnHide: false,
   tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    columns: [{
        header: getPersonModuleTranslation('ID'),
        dataIndex: 'id',
        sortable:true,
        flex: .1,
        hidden:true
    },{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        sortable:true,
        flex: .1
    },{
        header: getCommonTranslation('PROGRAM_CESM_CODE'),
        dataIndex: 'programCesmCode',
        sortable:true,
        flex: .1
    },{
        header: getCommonTranslation('COURSE_CESM_CODE'),
        dataIndex: 'courseCesmCode',
        sortable:true,
        flex: .1
    },{
        header: getPersonModuleTranslation('COURSE_CODE'),
        dataIndex: 'courseCode',
        sortable:true,
        flex: .1
    }, {
        header: getPersonModuleTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        sortable: true,
        flex: .1
    },  {
        header: getPersonModuleTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariantCount',
        sortable:true,
        flex: .1,
        renderer : function(val){
        	if (!isNullOrEmpty(val) && val > 0) {
        		return '<a href="#">'+val+'</a>';
        	} else {
        		return val;
        	}
		}
    },{
        header: getPersonModuleTranslation('COURSE_COMPONENT'),
        dataIndex: 'courseComponentName',
        sortable:true,
        flex: .1
    },{
        header: getProgramandcourseTranslation('INITIATOR_COMMENT'),
        dataIndex: 'intiatorComment',
        sortable:true,
        flex: .1,
        renderer: function(val, metaData) {
			if(!isNullOrEmpty(val)){
		    var encodedValue = Ext.String.htmlEncode(val).replace(/\n/g, '<br>');
		    metaData.tdAttr = 'data-qtip="' + encodedValue + '"'; // Tooltip to show full content on hover

		    return '<div class="faculty-course-interest-comment-cell">' + encodedValue + '</div>';
			}
		}
    },{
        header: getProgramandcourseTranslation('INITIATOR'),
        dataIndex: 'intiator',
        sortable:true,
        flex: .1
    },
    {
        header: getProgramandcourseTranslation('REQUEST_DATE'),
        dataIndex: 'requestDate',
        sortable:true,
        flex: .1,
        renderer: function(val) {
        	if(!isNullOrEmpty(val)){
    			return dateRender(val);
        	}
		}
        
    },{
        header: getCommonTranslation('ACTION_STATUS'),
        dataIndex: 'actionStatus',
        sortable:true,
        flex: .1
    }],
    
    initComponent: function() {
        var this$ = this;
        //var store = (this$.personType == 'STUDENT')?this$.buildStudentStore():this$.buildFacultyStore();
        var store = this$.buildFacultyStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
   /* buildStudentStore: function() {
        return Ext.create('Academia.store.personinfo.common.course.CourseAttendanceStore');
    },*/
    buildFacultyStore: function() {
        return Ext.create('Academia.store.personinfo.common.course.FacultyCourseInterestGridStr');
    }
});