/**
 * @author Ramkrishna Yadav
 */
var ExtendedTimeTableCBSGridStore = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.FacultyTeachingHourGridStore');
Ext.define('Academia.view.personinfo.common.course.FacutltyTeachingHourGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.facutltyTeachingHourGrid',
    title: getPersonModuleTranslation('TEACHING_HOURS'),
    border: true,
    store: ExtendedTimeTableCBSGridStore,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
   tbar: [{
	xtype: 'fieldcontainer',
	width: 'auto',
	items: [{
		xtype: 'button',
		itemId: 'btnSaveItemId',
		ui: 'CustomBtnSubmit',
		text: getCommonTranslation('SAVE'),
		//disabled:true
	 }]
	}],
    columns: [{
        header: getCommonTranslation('ACADEMIC_TERM'),
        dataIndex: 'academicTerm',
        sortable:true,
        flex: .1
    }, {
		header:getCommonTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},  {
		header:getCommonTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.1,
		sortable:true
	},{
        header: getPersonModuleTranslation('TEACHING_HOURS'),
        dataIndex: 'teachingHour',
        flex: .1,
        sortable: false,
        editor: {
			 xtype: 'numberfield',
			 itemId:'teachingHourId',
			valueField : 'value',
			 displayField : 'value',
			 typeAhead:false,
			 minValue:0,
			 //editable : false
			 hideTrigger: true,
		       // keyNavEnabled: false,
		      //  mouseWheelEnabled: false,
		      maxLength: 10
		 },
		 renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
	        	if(!isNullOrEmpty(record.data.teachingHour) && !isNullOrEmpty(value) && value !== '') {
	        		return value;
	        	}
	        	else{
	        		rec.tdCls = 'gridInputCustomStyle';
	        		return getExaminationTranslation('CLICK_TO_ENTER');
	        	}
	        }
    }],
    plugins: [{
		 ptype : 'cellediting',
		 clicksToEdit: 1,
		 listeners: {
			  beforeedit: function(editor, context) {
	            	var fceController = Academia.getApplication().getController('Academia.controller.personinfo.faculty.FacultyCourseExecutionController');
	            	var portalId = fceController.getCurrentLoggedPortalId();
	            	if (portalId == 2){
	            		return false;
	            	} else {
	                    var rowData = context.record.data;
	                    if (context.field == 'teachingHourId') {
	                        if (!context.record.raw.isStausEditable) {
	                            return false;
	                        }
	                    }
	            	}
	            },
			 edit: function(obj, editor, context){
				 var this$= this;
				 var grid = obj.grid;
				 var store = grid.getStore();
				 var models = grid.getStore().getRange();
				 for(var i =0; i<store.data.length;i++){
					 if(editor.rowIdx==i){
						 /*models[i].set('present', false);
						 models[i].set('absent', false);*/
					 }
				 }
			 }
		 }
	 }],
    
    initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
  
});