Ext.define('Academia.view.personinfo.common.course.PerformanceTrackerGrid', {
    extend: 'Ext.tree.Panel',
    
    requires: [
        'Ext.data.*',
        'Ext.grid.*',
        'Ext.tree.*'
    ],    
    alias: 'widget.performancsetrackergrid',
    title: getPersonModuleTranslation('PERFORMANCE_TRACKER_DETAILS'),
    border: true,
    autoScroll: true,
    useArrows: false,
    rootVisible: false,
    multiSelect: true,
    singleExpand: true,
    
    initComponent: function() {
        
        Ext.apply(this, {
            store: 'personinfo.common.course.PerformanceTrackerStore',
            columns: [{
                xtype: 'treecolumn',
                text: getPersonModuleTranslation('SUBJECT'),
                flex: 1,
                dataIndex: 'subject'
            },{
                text: getPersonModuleTranslation('MARKS'),
                flex: 1,
                sortable: true,
                dataIndex: 'marks',
                align: 'center'
            },{
                text: getPersonModuleTranslation('STATUS'),
                flex: 1,
                dataIndex: 'status'
            },{
                text: getPersonModuleTranslation('PERFORMANCE_COURSE_RANK'),
                flex: 1,
                dataIndex: 'courseRank'
            },{
                text: getPersonModuleTranslation('REVAL'),
                flex: 1,
                dataIndex: 'reval'
            },{
                text: getPersonModuleTranslation('MARKS_AFTER_REVAL'),
                flex: 1,
                dataIndex: 'marksAfterReval'
            },{
                text: getPersonModuleTranslation('STATUS'),
                flex: 1,
                dataIndex: 'status'
            },{
                text: getPersonModuleTranslation('PERFORMANCE_COURSE_RANK'),
                flex: 1,
                dataIndex: 'courseRankAfterReval'
            }]
        });
        
        this.callParent(arguments);
    }
    
});