/**
 *  Disciplinary Action SU Grid
 */
Ext.define('Academia.view.personinfo.common.disciplinaryactivity.DisciplinaryActionSUGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.disciplinaryactionsugrid',
    title: getPersonModuleTranslation('SP_DISCIPLINARY_ACTIONS_SU'),
    border: true,
    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
    isGridConfigurable: true,
	enableColumnHide: false,
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnAddStudentsSU',
        text: getCommonTranslation('ADD_STUDENTS'),
        tooltip: getCommonTranslation('ADD_STUDENTS'),
        disabled: true
    }],
    columns: [{
        header: getPersonModuleTranslation('TYPE_OF_MISCONDUCT'),
        dataIndex: 'misconductType',
        sortable: true,
        flex: .2,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return value.value; 
			}                        
		}
    },  {
        header: getPersonModuleTranslation('DATE_OF_MISCONDUCT'),
        dataIndex: 'studentDateOfMisconduct',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('TEMPORARY_SUSPENSION'),
        dataIndex: 'tempSuspension',
        sortable: true,
        flex: .2,
        renderer:function(value, meta, record) {
        	var val = '';
        	if(record.data.tempSuspension == true) {
        		val = 'Yes';
        	}else {
        		val = 'No'; 
        	}		
        	return val;
        }
    }, {
        header: getPersonModuleTranslation('TEMPORARY_SUSPENSION_DATE'),
        dataIndex: 'studentTempSuspensionDate',
        sortable: true,
        hidden:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('DISCIPLINARY_COMMITTEE'),
        dataIndex: 'disciplinaryCommittee',
        sortable: true,
        flex: .2,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return value.value; 
			}                        
		}
    }, {
        header: getPersonModuleTranslation('TEMPORARY_SUSPENSION_ACCESS_RESTRICTION'),
        dataIndex: 'tempAccessRestriction',
        sortable: true,
        flex: .2,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return value.value; 
			}                        
		}
    }, {
        header: getPersonModuleTranslation('TEMPORARY_SUSPENSION_LAPSE'),
        itemId: 'isTempSuspensionLapse',
        dataIndex: 'isTempSuspensionLapse',
        hidden:true,
        sortable: true,
        flex: .2,
        renderer:function(value, meta, record) {
        	var val = '';
        	if(record.data.isTempSuspensionLapse == true) {
        		val = 'Yes';
        	}else {
        		val = 'No'; 
        	}		
        	return val;
        }
	    },{
        header: getPersonModuleTranslation('TEMPORARY_SUSPENSION_LAPSE_DATE'),
        dataIndex: 'studentTempSuspensionLapseDate',
        itemId: 'tempSuspensionLapseDate',
        sortable: true,
        hidden:true,
        flex: .2
    }, {
		header:  getPersonModuleTranslation('DISCIPLINARY_DETERMINATION'),
		dataIndex: 'disciplinaryDetermination',
		sortable:true,
		hidden:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.disciplinaryCommitteeDetails.disciplinaryDetermination)) {
				return record.data.disciplinaryCommitteeDetails.disciplinaryDetermination.value; 
			}                        
		}
		}, {
        header: getPersonModuleTranslation('DISCIPLINARY_DETERMINATION_DATE'),
        dataIndex: 'studentDeterminationDate',
        sortable: true,
        hidden:true,
        flex: .2,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(record)) {
				return record.data.disciplinaryCommitteeDetails.studentDeterminationDate; 
			}                        
		}
    }, {
        header: getPersonModuleTranslation('DISCIPLINARY_COMMITTEE_HEARING_DATE'),
        dataIndex: 'studentDeterminationHearingDate',
        sortable: true,
        hidden:true,
        flex: .2,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(record)) {
				return record.data.disciplinaryCommitteeDetails.studentDeterminationHearingDate; 
			}                        
		}
    }, {
        header: getPersonModuleTranslation('IS_GUILTY'),
        dataIndex: 'isGuilty',
        sortable: true,
        flex: .2,
        renderer:function(value, meta, record) {
        	var isGuilty=record.data.disciplinaryCommitteeDetails.whetherGuilty;
        	var val = '';
        	if(isGuilty == true) {
        		val = 'Yes';
        	}else {
        		val = 'No'; 
        	}		
        	return val;
        }

    }, {
        header: getPersonModuleTranslation('APPEAL'),
        dataIndex: 'whetherAppealed',
        sortable: true,
        flex: .2,
        renderer:function(value, meta, record) {
        	var val = '';   
        	if(record.data.whetherAppealed == true) {
        		val = 'Yes';
        	}else {
        		val = 'No'; 
        	}		
        	return val;
        }
    }, {
        header: getPersonModuleTranslation('APPEAL_DATE'),
        dataIndex: 'studentAppealDate',
        sortable: true,
        flex: .2,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(record)) {
				return record.data.appealDetails.studentAppealDate;
			}                        
		}
    }, {
        header: getPersonModuleTranslation('APPEAL_OUTCOME'),
        dataIndex: 'appealOutcome',
        sortable: true,
        flex: .2,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(record)) {
				if(!isNullOrEmpty(record.data.appealDetails.appealOutcome)){
				   return record.data.appealDetails.appealOutcome.value; 
				}
			} 
			else{
				return "";
			}
		}
    }, {
        header: getPersonModuleTranslation('DETAILS_OF_MISCONDUCT'),
        dataIndex: 'misconductDetail',
        sortable: true,
        hidden:true,
        flex: .2,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(record)) {
				return record.data.appealDetails.misConductDetails; 
			}                        
		}
    }, {
        header: getPersonModuleTranslation('NOTES'),
        dataIndex: 'remarks',
        sortable: true,
        hidden:true,
        flex: .2,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(record)) {
				return record.data.appealDetails.remarks; 
			}                        
		}
    },{
        header: getPersonModuleTranslation('SANCTION_DETAILS'),
        dataIndex: 'sanctionDetails',
        sortable: true,
        flex: .2,
        renderer: function(value, metadata, record) {
    		return '<a href="#">' + "View" + '</a>';
    	}
    },{
        header: getCommonTranslation('STUDENTS_INVOLVED'),
        itemId: 'studentInvolvedItemIdSu',
        dataIndex: 'disciplinaryActionDetails',
        sortable: true,
        flex: .2,
		renderer:function(value, meta, record){
			var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
			var portalId = baseController.getCurrentLoggedPortalId();
			if(!isNullOrEmpty(value) && portalId!=3 && portalId!=7) {	
				if(record.data.disciplinaryActionDetails.length){
					return '<a href=#>'+record.data.disciplinaryActionDetails.length+'<a>';
				}
			}else if(!isNullOrEmpty(value)){
				if(record.data.disciplinaryActionDetails.length){
					return record.data.disciplinaryActionDetails.length;
				}
			}
			return '';
		}
    },{
		header:  getPersonModuleTranslation('DOCUMENTS'),
		dataIndex: 'documents',
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				if(record.data.documents.length>0) {					
					return '<a href="#">' + "View" + '</a>';
				} 
			}                        
		}
    }],
    listeners: {
        selectionchange: {
            fn: function(model, selected) {
                model.view.up().down('#btnAddStudentsSU').setDisabled(!selected.length);
            },
            scope: this
        }
       

	},
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
                       
         this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.disciplinaryactivity.DisciplinaryActionSUStore');
    }

});