/**
 * @Author Vyabha Thakur
 */
Ext.define('Academia.view.personinfo.common.pasthistory.EducationHistoryDetailForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.educationhistorydetailform',
	border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
    items: [{
        xtype: 'hidden',
        itemId: 'education_history_Details_hidden_field',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('NAME_OF_INSTITUTIONS_ATTENDED'),
            itemId : "nameOfInstitutionsAttended",
            name: 'nameOfInstitutionsAttended',
            allowBlank: false,
            maxLength:255,
		},{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('HIGHEST_QUALIFICATION'),
            itemId : "highestQualification",
            name: 'highestQualification',
            allowBlank: true,
            maxLength:255,
		},]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
			xtype: 'datefield',
			fieldLabel: getCommonTranslation('GRADUATION_DATE'),
			itemId : "graduationDate",
            name: 'graduationDate',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype : 'daterange'
		}]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studenteducationhistorydocumentgrid',
			itemId:'studenteducationhistorydocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studenteducationhistoryurlgrid',
			itemId:'studenteducationhistoryurlgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'applicanteducationhistorydocumentgrid',
			itemId:'applicanteducationhistorydocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'applicanteducationhistoryurlgrid',
			itemId:'applicanteducationhistoryurlgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },{
			 xtype: 'button',
			 name: 'graduationDocument',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'graduationDocument',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		},{
			 xtype: 'button',
			 name: 'graduationDocumentUrl',
			 text:getCommonTranslation('UPLOAD_URL'),
			 itemId: 'graduationDocumentUrl',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
