/**
 *  Extra Curricular Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.ExtraCurricularGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.extracurriculargrid',
    title: getPersonModuleTranslation('EXTRA_CURRICULAR_ACTIVITY'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'stdExtraCurrAddStudentsBtn',
        text: getCommonTranslation('ADD_STUDENTS'),
        tooltip: getCommonTranslation('ADD_STUDENTS'),
        disabled: true
    }],
    columns: [{
        header: getPersonModuleTranslation('EVENT_NAME'),
        dataIndex: 'eventId',
        sortable: true,
        flex: .2,
        renderer : function(obj, meta, record, rowIndex){
        	if(isNullOrEmpty(record.data.otherEvent) && obj!=null) {
        		if(obj.value == 'OTHEREVENT'){
        			return 'Other Event';
        		}else{
        			return columnObjRender(obj, "value");
        		}
        	} else if(isNullOrEmpty(record.data.otherEvent) && obj==null) {
        		return "";
        	}
        	else {
        		return record.data.otherEvent;
        	}
        }
    },{
        header: getPersonModuleTranslation('ACTIVITY_NAME'),
        dataIndex: 'activityName',
        sortable: true,
        flex: .2
    },{
        header: getPersonModuleTranslation('ACTIVITY_TYPE'),
        dataIndex: 'activityType',
        sortable:true,
        flex: .2,
        renderer : function(obj){
        	return columnObjRender(obj, "value");
        }
    }, {
        header: getPersonModuleTranslation('CONDUCT_ORGANIZATION'),
        dataIndex: 'organization',
        sortable:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('AWARD_RECIEVED'),
        dataIndex: 'performance',
        sortable:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('AWARD_DATE'),
        dataIndex: 'awardDate',
        sortable:true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getPersonModuleTranslation('REMARK'),
        dataIndex: 'remarks',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('EVENT_HELD'),
        dataIndex: 'isCurrentOrganization',
        sortable:true,
        flex: .2,
        renderer : function(value){
        	var msg = "";
        	if(value == true){
        		msg = getPersonModuleTranslation('AFTER_JOINING');
        	}else{
        		msg = getPersonModuleTranslation('BEFORE_JOINING');
        	}
        	
        	return msg;
        }
    }],
    listeners: {
        selectionchange: {
            fn: function(model, selected) {
                model.view.up().down('#stdExtraCurrAddStudentsBtn').setDisabled(!selected.length);
            },
            scope: this
        }
    },
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.pasthistory.ExtraCurricularStore');
    }

});