Ext.define('Academia.view.personinfo.common.pasthistory.FacultyNonAcademicAchievementsGrid', {
	extend: 'Ext.grid.Panel',
    //extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.facultynonacademicachievementsgrid',
    title: getPersonModuleTranslation('NON_ACADEMIC_ACHIEVEMENTS'),
    border: true,
    viewConfig: {
		stripeRows : CONSTANTS.STRIPEROWS
		},
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
       },
    {xtype: 'button',
    itemId: 'btnEdit',
    tooltip: getCommonTranslation('EDIT'),
    glyph: ICONGLYPH.EDITGLYPH,
    hasDisableForProfileViewMode:true
}, {
    xtype: 'button',
    itemId: 'btnView',
    tooltip: getCommonTranslation('VIEW'),
    iconCls: 'view-icon'
}, {
    xtype: 'button',
    itemId: 'btnDelete',
    cls: 'CustomToolbarBtnReject',
    tooltip: getCommonTranslation('DELETE'),
    glyph: ICONGLYPH.DELETEGLYPH,
    hasDisableForProfileViewMode:true
}],
    columns: [{
        header: getCommonTranslation('SPORT_EVENT'), 
        dataIndex: 'sportEventValue',
        sortable:true,
        flex: .2,
       /* renderer : function(obj){
        	return columnObjRender(obj, "value");
        }*/
    }, {
        header: getCommonTranslation('LEVEL_EVENT'), 
        dataIndex: 'levelEventValue',
        sortable: true,
        flex: .2
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        
        this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.pasthistory.FacultyNonAcademicAchievementsGridStore');
    }
});