/**
 *  @Dharmendra.Prajapati
 *  Patent Details Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.PatentDetailsGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.patentdetailsgrid',
    title: getPersonModuleTranslation('PATENT_DETAILS'),
    border: true,
    isGridConfigurable: true,
	enableColumnHide: false,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
    columns: [{
        header: getCommonTranslation('PATENT_TYPE'),
        dataIndex: 'patentTypeSM',
        sortable: true,
        flex: .2,
        renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return value.value;
			}
			return '';
		}
    }, {
        header: getCommonTranslation('PATENT_NAME'),
        dataIndex: 'patentName',
        sortable:true,
        flex: .2
    }, {
        header: getCommonTranslation('DATE_OF_PATENT_FILED'),
        dataIndex: 'dateOfPatentFiled',
        sortable:true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getCommonTranslation('DATE_OF_PATENT_AWARDED'),
        dataIndex: 'dateOfPatentAwarded',
        sortable:true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    },{
        header: getCommonTranslation('DOCUMENT'),
        dataIndex: 'noOfdocument',
        sortable:true,
        flex: .2,
        renderer : function(val){
        	if (!isNullOrEmpty(val) && val > 0) {
        		return '<a href="#">'+val+'</a>';
        	}
		}
    },{
        header: getCommonTranslation('PATENT_OTHER_DETAILS'),
        dataIndex: 'otherDetails',
        hidden: true,
        sortable: true,
        flex: .2,
        renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if(!isNullOrEmpty(val)){
        		var valtext=val.substring(0, 40);
        	 	rec.tdAttr = 'data-qtip="' + val + '"';
        	rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
        	rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 4;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
        	return valtext;
        	}
        	else{
        		return "";
        		}
        	}
       },{
           header: getCommonTranslation('MAPPED_SUPERVISORS'),
           dataIndex: 'supervisorId',
           sortable:true,
           hidden: true,
           flex: .2,
           renderer:function(val,rec,record,rowIndex,colIndex,store,view){
           	if (!isNullOrEmpty(val)) {
           		if(val.length==1){
           			if(val[0].supervisorIds!=null){
           				return '<a href="#">'+val.length+'</a>';
           			}else 
                   		return "";
           		}
           		return '<a href="#">'+val.length+'</a>';
           	}else 
           		return "";
   		}
       }, {
    	   header: getCommonTranslation('DEFENCE_DATE'),
           dataIndex: 'defenceDate',
           sortable:true,
           flex: .2,
           hidden: true,
   		   renderer:function(date) {
   			   return dateRender(date);
   		   }
       }],

   initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.pasthistory.PatentTypeGridStr');
    }

});