/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.common.pasthistory.QualificationDetailsWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.qualificationdetailswin',
	title: getCommonTranslation('QUALIFICATION_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		plugins : "formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype:'hidden',
			itemId:'recordId',
			name:'recordId'
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top',
				xtype: 'customcombobox',
				editable:false,
				forceSelection: true,
			},
			items:[{
				name: 'qualificationType',
				itemId:'qualificationType',
				store: 'personinfo.common.pasthistory.EmpQualificationTypeStore',
				fieldLabel: getCommonTranslation('QUALIFICATION_TYPE'),
				allowBlank:false,
				valueField: 'id',
				displayField: 'value',
			},{
				name: 'qualificationCategory',
				itemId:'qualificationCategory',
				store:'personinfo.common.pasthistory.EmpQualificationCategoryStore',
				allowBlank:false,
				valueField: 'id',
				displayField: 'value',
				fieldLabel: getCommonTranslation('QUALIFICATION_CATEGORY'),
			},{
				name: 'qualificationName',
				itemId:'qualificationName',	
				store:'personinfo.common.pasthistory.EmpQualificationNameStore',
				allowBlank:false,
				valueField: 'id',
				displayField: 'value',
				fieldLabel: getCommonTranslation('EMP_QUALIFICATION_NAME'),
			},{
				name: 'major1',
				itemId:'major1',
				store:'personinfo.common.pasthistory.EmpQualificationMajorOneStore',
				valueField: 'id',
				displayField: 'value',
				fieldLabel: getCommonTranslation('MAJOR_1'),
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top',
				xtype: 'customcombobox',
				editable:false,
			},
			items:[{
				name: 'major2',
				itemId:'major2',
				store:'personinfo.common.pasthistory.EmpQualificationMajorTwoStore',
				fieldLabel: getCommonTranslation('MAJOR_2'),
				valueField: 'id',
				displayField: 'value',
			},{
				name: 'major3',
				itemId:'major3',
				store:'personinfo.common.pasthistory.EmpQualificationMajorThreeStore',
				fieldLabel: getCommonTranslation('MAJOR_3'),
				valueField: 'id',
				displayField: 'value',
			},{
				name: 'HEQFLevel',
				itemId:'HEQFLevel',
				store:'personinfo.common.pasthistory.EmpQualificationHEQFLevelStore',
				fieldLabel: getCommonTranslation('HEQF_LEVEL'),
				valueField: 'id',
				displayField: 'value',
			},{
				xtype: 'customcombobox',
				name: 'institution',
				itemId:'institution',
				store:'personinfo.common.pasthistory.EmpQualificationInstitutionStore',
				fieldLabel: getCommonTranslation('INSTITUTION'),
				editable:false,
				valueField: 'id',
				displayField: 'value',
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top',
				xtype: 'customcombobox',
				editable:false,
			},
			items:[{
				xtype: 'datefield',
				name: 'qualificationStartDate',
				itemId:'qualificationStartDate',
				fieldLabel: getCommonTranslation('QUALIFICATION_START_DATE'),
				vtype: 'daterange',
				endDateField: 'qualificationEndDate',
				editable:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
			},{
				xtype: 'datefield',
				name: 'qualificationEndDate',
				itemId:'qualificationEndDate',
				fieldLabel: getCommonTranslation('QUALIFICATION_END_DATE'),
				vtype: 'daterange',
				startDateField: 'qualificationStartDate',
				editable:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				name: 'qualificationApprovalLevel',
				itemId:'qualificationApprovalLevel',
				store:'personinfo.common.pasthistory.EmpQualificationApprovalLevelStore',
				fieldLabel: getCommonTranslation('QUALIFICATION_APPROVAL_LEVEL'),
				valueField: 'id',
				displayField: 'value',
			},{
				name: 'qualificationUsedInApproval',
				itemId:'qualificationUsedInApproval',
				store:'personinfo.common.pasthistory.EmpQualificationUsedInApprovalStore',
				fieldLabel: getCommonTranslation('QUALIFICATION_USED_IN_APPROVAL'),
				valueField: 'id',
				displayField: 'value',
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'checkboxfield',
				labelAlign: 'right',
				itemId:'completed',
				boxLabel: getCommonTranslation('COMPLETED'),
				name: 'completed',
				inputValue : true
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'qualificationDetailFormSave',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'qualificationDetailFormCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});
