/**
 * Student Engagement Form
 */
Ext.define('Academia.view.personinfo.common.pasthistory.StudentEngagementForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentengagementform',
    cls: 'horizontalScrollingFixed',
    autoScroll: false,
    bodyPadding: '10 10 10 11',
    //frame:true,
    plugins: "formlabelrequired",
    itemId: 'studentengagementformId',
    style: {
        marginLeft: CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    defaults: {
        labelAlign: 'top',
    },
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'hiddenfield',
        	name: 'id'
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ITT_ENTRY_ROUTE'),
            name: 'entryRouteName',
            itemId: 'entryRouteNameId',
            store: Ext.create('Academia.store.personinfo.common.pasthistory.IttEntryRouteStore'),
            displayField: 'value',
            valueField: 'id',
            editable: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('FEE_ELIGIBILITY'),
            name: 'feeEligibilityName',
            itemId: 'feeEligibilityId',
            store: Ext.create('Academia.store.personinfo.common.pasthistory.FeeEligibilityStore'),	
            displayField: 'value',
            valueField: 'id',
            editable: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('QUALIFIED_TEACHER_STATUS'),
            name: 'qualifiedTeacherStatusName',
            itemId: 'qualifiedTeacherStatusId',
            store: Ext.create('Academia.store.personinfo.common.pasthistory.QualifiedTeacherStatusStore'),
            displayField: 'value',
            valueField: 'id',
            editable: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('RESEARCH_COUNCIL_STUDENT_IDENTIFIER'),
            name: 'councilStudentIdentyName',
            itemId: 'councilStudentIdentyId',
            maxLength: 50,
            enforceMaxLength: true
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('RESEARCH_COUNCIL_STUDENT'),
            name: 'researchcouncilStudentName',
            itemId: 'researchcouncilStudentId',
            store: Ext.create('Academia.store.personinfo.common.pasthistory.ResearchCouncilStudentStore'),
            displayField: 'value',
            valueField: 'id',
            editable: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('NHS_EMPLOYER'),
            name: 'nhsEmployerName',
            itemId: 'nhsEmployerId',
            store: Ext.create('Academia.store.personinfo.common.pasthistory.NHSEmployerStore'),
            displayField: 'value',
            valueField: 'id',
            editable: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('STUDY_INTENTION'),
            name: 'studyIntentionName',
            itemId: 'studyIntentionId',
            store: Ext.create('Academia.store.personinfo.common.pasthistory.StudyIntentionStore'),
            displayField: 'value',
            valueField: 'id',
            editable: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            }
        }, {
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('UKRI_STUDENTSHIP_REFERENCE_NUMBER'),
            name: 'ukriRefNoName',
            itemId: 'ukriRefNoId',
            maxLength: 50,
            enforceMaxLength: true
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('INCOMING_EXCHANGE'),
            name: 'incomingExchangeName',
            itemId: 'incomingExchangeId',
            store: Ext.create('Academia.store.personinfo.common.pasthistory.IncomingExchangeStore'),	
            displayField: 'value',
            valueField: 'id',
            editable: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation("SAVE"),
            name: 'saveBtn',
            itemId: 'saveBtn',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            /*
                			xtype: 'button',
                			itemId: 'resetBtn',
                			name: 'resetBtn',
                			text: getCommonTranslation("CANCEL"),
                			ui:'CustomBtnCancel',
                			scale: CONSTANTS.BUTTONSIZE,
                		*/
        }]
    }]
});