/**
 *
 * @author priyanshi sharma
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.FinancialSupportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.financialsupportgrid',
	title: getPersonModuleTranslation('FINANCIAL_SUPPORT'),
	border: true,
	viewConfig: {
		stripeRows: true
	},
	initComponent: function() {    	     
    	var grid=this;
    	grid.addExportToolBarItems(grid);
    	var store=Ext.create('Academia.store.personinfo.common.paymentandrefund.FinancialSupportStore');
    	Ext.apply(this, {
    		store: store        
    	});
    	this.callParent(arguments);
    	var custompagingtoolbar=grid.down('custompagingtoolbar');
    	if(custompagingtoolbar){
    		custompagingtoolbar.bindStore(store);        	
    	}
    },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		glyph: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex: .2
	}, {
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex: .2
	},{
		header: getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex: .2
	},{
		header: getCommonTranslation('ACCESS_AND_PARTICIPATION_FLAG'),
		dataIndex: 'accessAndParticipationFlag',
		flex: .2
	},{
		header: getCommonTranslation('FINANCIAL_SUPPORT_AMOUNT'),
		dataIndex: 'financialSupportAmount',
		flex: .2
	},{
		header: getCommonTranslation('FINANCIAL_SUPPORT_TYPE'),
		dataIndex: 'financialSupportType',
		flex: .2
	}]
});