/**
 * @author Ramkrishna yadav
 */
Ext.define('Academia.view.personinfo.common.personalinfo.StudentHoldsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentholdsgrid',
	store: 'student.managehold.StudentApplyHoldGridStore',
	title: getCommonTranslation("HOLDS"),
	border: true,
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.managehold.StudentApplyHoldGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'applyHold',
		tooltip: getCommonTranslation('APPLY_HOLD'),
		text: getCommonTranslation('APPLY_HOLD'),
	}, {
		xtype: 'button',
		itemId: 'removeHold',
		tooltip: getCommonTranslation('REMOVE_HOLD'),
		text: getCommonTranslation('REMOVE_HOLD'),
	},{
		xtype: 'button',
		itemId: 'deleteHold',
		tooltip: getCommonTranslation('DELETE_HOLD'),
		text: getCommonTranslation('DELETE_HOLD'),
	}],
	columns: [{
		header:  getCommonTranslation("HOLD_CATEGORY_NAME"),
		dataIndex:'holdCategoryName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("HOLD_SUB_CATEGORY_NAME"),
		dataIndex: 'subHoldCategoryName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("APPLIED_DATE"),
		dataIndex: 'studentHoldAppliedDate',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("APPLIED_BY"),
		dataIndex: 'holdAppliedBy',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("APPLY_HOLD_AT"),
		dataIndex: 'appliedHoldAt',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			var val;
			if(value=='COURSE_ENROLLMENT'){
				val =getCommonTranslation("COURSE_ENROLLMENT");
			}else if(value=='PROGRAM_BATCH_SECTION_ENROLLMENT'){
             	val =getCommonTranslation("PROGRAM_BATCH_SECTION_ENROLLMENT");
            }else if(value=='RESULT_PUBLISH'){
				val =getCommonTranslation("RESULT_PUBLISH");
			}else if(value=='HALL_TICKET_PUBLISH'){
				val =getCommonTranslation("HALL_TICKET_PUBLISH");
			}else if(value=='PROMOTION'){
				val =getCommonTranslation("PROMOTION");
			}else if(value=='PORTAL_ACCESS'){
				val =getCommonTranslation("PORTAL_ACCESS");
			}else if(value=='NONE'){
				val =getCommonTranslation("NONE");
			}else if(value=='COMMUNICATION_HOLD'){
				val =getCommonTranslation("COMMUNICATION_HOLD");
			}else if(value=='LOCK_PERSONAL_DETAILS'){
				val =getCommonTranslation("LOCK_PERSONAL_DETAILS");
			}
			return val;
		}
	},{
		header:  getCommonTranslation("REASON_FOR_APPLYING_HOLD"),
		dataIndex: 'reasonForApply',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("REMOVAL_DATE"),
		dataIndex: 'studentHoldRemovalDate',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("REMOVAL_BY"),
		dataIndex: 'holdRemovalBy',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("REASON_TO_REMOVE_HOLD"),
		dataIndex: 'reasonForRomove',
		flex:.1,
		sortable:true
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.student.managehold.StudentApplyHoldGridStore');
	}
});