/**
 * @author Suraj Chouhan
 *
 */
Ext.define('Academia.view.personinfo.common.personalinfo.StudentInsuranceUrlGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.studentinsuranceurlgrid',
    store : 'personinfo.common.personalinfo.StudentInsuranceUrlGridStore',
	border: true,
	refreshStoreData:true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [
	{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH		
	
	}],
	columns :[{
		header : getPersonModuleTranslation('DOCUMENT_URL_NAME'),
		dataIndex : 'documentName',
		flex:1,
		sortable :false,
		renderer:function(value,rec){
		    var value1=!isNullOrEmpty(value)?value:rec.record.data.name;
            var newPath=rec.record.data.path;    
            var val=!isNullOrEmpty(value1)?value1:newPath;
            return "<a href="+newPath+" target='_blank'>"+val;
		}
	}]

});

