/**
 * @author <a href="vyabha.thakur@serosoft.in">Vyabha Thakur</a>
 *
 */
Ext.define('Academia.view.personinfo.common.postgraduatemanagement.StudentThesisTitleForm', {
     extend: 'Ext.form.Panel',
    // extend: 'Academia.view.common.CustomFieldForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.studentthesistitleform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'student_thesis_title_hidden_field',
        name: 'id'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items:[{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'), //Program
			name: 'programId',
			itemId: 'programId',
			//autoload: true,
			store: 'student.postGraduateManagement.StudentThesisActiveProgramStore',
			valueField: 'id',
			displayField: 'valueCode',
			queryMode:'local',
			queryParam:'qry',
			allowBlank:false,
			typeAhead : false,
            forceSelection:true
		},{
			xtype: 'textfield',
			name: 'title',
			itemId:'titleId',
			displayField:'name',
			allowBlank:false,
			width: 226,
			maxLength:300,
			fieldLabel:getCommonTranslation('TITLE')
        },{
   	   	 xtype : 'radiogroup',
   		 itemId:'classifiedId',
   		 name:'classified',
   	     defaults: {flex: 1},
   	     fieldLabel: getCommonTranslation('CLASSIFIED'),
   	     columns: 2,
   	     width: 226,
   	     vertical: false,
   	     allowBlank:false,
   	     layout: {
   	    	 type: 'hbox'
   	     },
   	     items : [{
   	   		 boxLabel : getCommonTranslation('YES'),
   	   		 name : 'classified',
   	   		 inputValue : true
   	   	 },{
   	   		 boxLabel : getCommonTranslation('NO'),
   	   		 name : 'classified',
   	   		 inputValue : false,
   	   		 checked : true
   	   	 }]
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{ 
			xtype: 'textareafield',
			name: 'shortSummaryForGraduation',
			itemId : 'shortSummaryForGraduation',
			fieldLabel: getCommonTranslation('SHORT_SUMMARY_FOR_GRADUATION'),
			labelAlign: 'top',
			width: 440,                
			maxLength:1000
		},{ 
			xtype: 'textareafield',
			name: 'supervisorSummaryForReading',
			itemId : 'supervisorSummaryForReading',
			fieldLabel: getCommonTranslation('SUPERVISOR_SUMMARY_FOR_READING'),
			labelAlign: 'top',
			width: 440,                
			maxLength:500
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
        	xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('APPROVAL_BODY'),
			store: 'common.ThesisApprovalBodyStore',
			itemId: 'approvalBody',
			name: 'approvalBody',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank: true
		},{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('APPROVAL_DATE'),
            itemId : "approvalDate",
            name: 'approvalDate',
          // --submitFormat: CONSTANTS.DATE_FORMAT,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: true,
            vtype : 'daterange'
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('APPROVAL_STATUS'),
			store: 'common.ThesisApprovalStatusStore',
			itemId: 'approvalStatus',
			name: 'approvalStatus',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank: true
		}]
    },{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 260
	        },
	    items: [{
	    	xtype: 'datefield',
	    	fieldLabel: getCommonTranslation('AUDIT_DATE'),
	    	// --submitFormat: CONSTANTS.DATE_FORMAT,
	    	itemId: 'auditDateItemId',
	    	name: 'auditDate',
	    	listeners: {
	    		render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
          },
        allowBlank: false,
        vtype : 'daterange',
	    },{
        xtype: 'textfield',
        fieldLabel: getCommonTranslation('AUDIT_ID'),
        itemId: 'auditIdItemId',
        name: 'auditId',
        readOnly : true,
        allowBlank: false
	    }]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('REF2021_UNIT_OF_ASSESSMENT'),
			store: 'common.unitOfAssessmentStore',
			itemId: 'unitOfAssessmentId',
			name: 'unitOfAssessment',
			valueField: 'id',
			displayField: 'value',
			editable: false,
		},{
			xtype: 'textfield',
		    fieldLabel: getCommonTranslation('SUPERVISOR_ALLOCATION_IDENTIFIER'),
		    itemId: 'supervisorIdentifierId',
		    name: 'supervisorIdentifier',
		    //valueField: 'id',          
		    displayField: 'value',      
		    editable: false,
		},{
			xtype: 'numberfield',
			fieldLabel: getCommonTranslation('SUPERVISOR_ALLOCATION_PROPORTION'),
			itemId: 'supervisorProportionId',
			name: 'supervisorProportion',
			valueField: 'id',          
		    displayField: 'value',      
		    minValue: 0,
		    maxValue: 100,
		    allowDecimals: true,
		    decimalPrecision: 1,
		    hideTrigger: false,
		    step: 0.1,
		    enableKeyEvents: true 
		}]
	},{
        xtype: 'fieldcontainer',
        width: '100%',        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});
