/**
 * This view is used for request executed history
 * @author sachin.bangar
 */
Ext.define('Academia.view.personinfo.common.request.RequestExecutedHistoryGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.requestexecutedhistorygrid',
    title: getPersonModuleTranslation('REQUEST_EXECUTED_HISTORY'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }],
    columns: [{
        header: getPersonModuleTranslation('REQUEST_ID'),
        dataIndex: 'REQUEST_ID',
        sortable: true,
        flex: .2,
        renderer: function(value){
        	return '<a href="#">'+ value +'</a>';
        }
    }, {
        header: getPersonModuleTranslation('REQUEST_CATEGORY'),
        dataIndex: 'REQUEST_TYPE',
        sortable: true,
        flex: .2,
        renderer : function(value){
        	if(value == 'PROGRAM'){
        		value = getServiceRequestTranslation('PROGRAM');
        	}else if(value == 'COURSES'){
        		value = getServiceRequestTranslation('COURSES');
        	}else if(value == 'COMMUNITY'){
        		value = getServiceRequestTranslation('COMMUNITY');
        	}else if(value == 'OTHER'){
        		value = getServiceRequestTranslation('OTHER');
        	}else if(value == 'LEAVE'){
        		value = getServiceRequestTranslation('LEAVE');
        	}else if(value == 'PROGRAM_TRANSFER'){
        		value = getServiceRequestTranslation('PROGRAM_TRANSFER');
        	}else if(value == 'COURSE_TRASNFER'){
        		value = getServiceRequestTranslation('COURSE_TRASNFER');
        	}else if(value == 'SECTION_TRASNFER'){
        		value = getServiceRequestTranslation('SECTION_TRASNFER');
        	}else if(value == 'CERTIFICATE'){
        		value = getServiceRequestTranslation('CERTIFICATE');
        	}else if(value == 'SERVICE_SUBSCRIBE_WITHDRAW'){
        		value = getServiceRequestTranslation('SERVICE_SUBSCRIBE_WITHDRAW');
        	}else if(value == 'FEE_CONCESSION'){
        		value = getServiceRequestTranslation('FEE_CONCESSION');
        	}else if(value == 'FEE_RELATED'){
        		value = getServiceRequestTranslation('FEE_RELATED');
        	}else if(value == 'SCHOLARSHIP'){
        		value = getServiceRequestTranslation('SCHOLARSHIP');
        	}else if(value == 'DEBARMENT'){
        		value = getServiceRequestTranslation('DEBARMENT');
        	}else if(value == 'TERMINATION'){
        		value = getServiceRequestTranslation('TERMINATION');
        	}else if(value == 'PROGRAM_WITHDRAWAL'){
        		value = getServiceRequestTranslation('PROGRAM_WITHDRAWAL');
        	}else if(value == 'FREE_FORM'){
        		value = getServiceRequestTranslation('FREE_FORM');
        	}else if(value == 'PERSONAL_DATA_CHANGE'){
        		value = getServiceRequestTranslation('PERSONAL_DATA_CHANGE');
        	}else if(value == 'TRANSFER'){
        		value = getServiceRequestTranslation('TRANSFER');
        	}else if(value == 'COURSE_TRANSFER'){
        		value = getServiceRequestTranslation('COURSE_TRANSFER');
        	}else if(value == 'SECTION_TRANSFER'){
        		value = getServiceRequestTranslation('SECTION_TRANSFER');
        	}else if(value == 'COURSE_WITHDRAWAL'){
        		value = getServiceRequestTranslation('COURSE_WITHDRAWAL');
        	}else if(value == 'STUDENT_TRANSFER'){
        		value = getServiceRequestTranslation('STUDENT_TRANSFER');
        	}else if(value == 'TRANSFER'){
        		value = getServiceRequestTranslation('TRANSFER_REQ_CAT');
        	}else if(value == 'SCHOOL_LEAVING'){
        		value = getServiceRequestTranslation('SCHOOL_LEAVING');
        	}
        	return value;
        }
    }, {
        header: getPersonModuleTranslation('REQUEST_TYPE'),
        dataIndex: 'SR_REQUEST_TYPE',
        sortable: true,
        flex: .2,
        renderer : function(value){
        	if(value == 'FEE_CONCESSION'){
        		value = getServiceRequestTranslation('FEE_CONCESSION');
        	}else if(value == 'SCHOOL_LEAVING'){
        		value = getServiceRequestTranslation('SCHOOL_LEAVING');
        	}
        	return value;
        }
    },{
        header: getPersonModuleTranslation('REQUEST_SUB_TYPE'),
        dataIndex: 'REQUEST_SUB_TYPE',
        sortable: true,
        hidden:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('REQUEST_DATE'),
        dataIndex: 'REQUEST_DATE',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getPersonModuleTranslation('EXECUTION_DATE'),
        dataIndex: 'EXECUTION_DATE',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    },{
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'STATUS',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('REMARKS'),
        dataIndex: 'REMARKS',
        sortable: true,
        flex: .2
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.request.RequestExecutedHistoryStore');
    }
});