/**
 * Community Opt Grid 
 */
Ext.define('Academia.view.personinfo.common.services.CommunityOptGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.communityoptgrid',
    title: getPersonModuleTranslation('COMMUNITY_DETAILS'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
    columns: [{
        header: getPersonModuleTranslation('COMMUNITY_NAME'),
        dataIndex: 'community',
        sortable: true,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }, {
        header: getPersonModuleTranslation('DATE_OF_JOIN'),
        dataIndex: 'joiningDate',
        sortable: true,
        flex: .2,
        renderer : function(date) {
        	return dateRender(date);
        }
    }, {
        header: getPersonModuleTranslation('DATE_OF_EXIT'),
        dataIndex: 'exitDate',
        sortable: true,
        flex: .2,
        renderer : function(date) {
        	return dateRender(date);
        }
    }, {
        header: getPersonModuleTranslation('REMARK'),
        dataIndex: 'remark',
        sortable: true,
        flex: .2
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
    	var this$ = this;
    	var store = '';
    	if(this$.itemId === 'communityHistoryGrid'){
    		store = Ext.create('Academia.store.personinfo.common.services.CommunityHistoryStore');
    	}else{
    		store = Ext.create('Academia.store.personinfo.common.services.CommunityOptStore');
    	}
        return store;
    }
});
