/**
 * @author <a href="phool.gour@serosoft.in">Phool Singh  Gour</a>
 *
 */
Ext.define('Academia.view.personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.vaccinationinfodocumentlistgrid',
	store :'personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentListStore',
	border: true,
	autoScroll: false,
	height:'80%',
	frame:false,
	enableColumnHide :false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	title : getCommonTranslation('LIST_OF_DOCUMENTS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.common.vaccinationinfoactivity.VaccinationInfoDocumentListStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
	this.callParent(arguments);
	},
	
	tbar: [{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
				
	},'->',{
		xtype : 'button',
		itemId : 'downloadDocumentItemId',
		tooltip : getCommonTranslation('DOWNLOAD_ALL'),
		text : getCommonTranslation('DOWNLOAD_ALL'),
		formBind:true,
	}],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		align: 'left',
		flex: 0.5,
		sortable: false,
		renderer: function(value, metaData, record, rowIndex){
			return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
		}
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'documentName',
		flex:1,
		sortable: false,
		renderer:function(value,rec){
			if(value){
				return "<a href='#'>"+value+"</a>";
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		flex:1,
		sortable: false,
		renderer: function(date) {
            return dateRender(date);
        }
	}]
});