/**
 * @author Amit G
 */
Ext.define('Academia.view.personinfo.dashlet.StudentProfileProgressWeightDashlet', {
	extend : 'Academia.view.personinfo.dashlet.PersonInfoDashboardDashlet',
	alias : 'widget.studentprofileprogressweightdashlet',

	/* requires : ['Academia.view.dashboard.dashlets.GridDashlet',
               'Academia.model.common.AcademyLocationProgramModel' ], */

	graphView:true,
	layout:'card',
	activeItem: 0, 
	cls:'StudentProfileProgressWeightDashletCLS dashlet',
	loadPersonInfoDashboard :function(){
		var this$=this;
		var view= this.layout.getActiveItem();
		var studentProfile = this$.up('studentprofile');
    	var studentId = studentProfile.getUserId();
		if(view.xtype=='griddashlet' || view.xtype=='studenttipchartforweight'){
			var store= view.getStore();
			var extraparams=this$.getParams();
			store.getProxy().extraParams = {
				userId: studentId,
			};
			store.load({params:extraparams,
				callback: function(rec, operation, success) {
					if(isNullOrEmpty(rec) || rec.length==0){
						this$.layout.setActiveItem(2);
					}
				}
			});
		}else{
			if(view.xtype=='image'){
				this.layout.setActiveItem(0);
				var view1=this.layout.getActiveItem();
				var store= view1.getStore();
				var extraparams=this$.getParams();
				store.getProxy().extraParams = {
					userId: studentId,
				};
				store.load({params:extraparams,
					callback: function(rec, operation, success) {
						if(isNullOrEmpty(rec) || rec.length==0){
							this$.layout.setActiveItem(2);
						}
					}
				});
			}
		}
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
	},

	items:[{
		xtype : 'studenttipchartforweight',
		itemId:'studenttipchartforweightItemId',
		xAxesCategoryField :['mnthYear'],
		yAxesNumericField : 'studentWeight',
		yAxesNumericField1 : 'classAvgWeight',
		yAxesNumericField2 : 'ageAvgWeight',
		model:'Academia.model.student.studentprofile.StudentProgressReportModel',
		url : SERVERURL.STUDENT_WEIGHT_GRAPH_DASHLET,
		listeners:{
			activate:function(portlet){
				var studentprofileprogressweightdashlet=portlet.up('studentprofileprogressweightdashlet');
				studentprofileprogressweightdashlet.activeTab = 1;
				studentprofileprogressweightdashlet.addGridViewButton(studentprofileprogressweightdashlet);
				//studentprofileprogressweightdashlet.addExportToPng(studentprofileprogressweightdashlet,portlet);
			},
			deactivate:function(portlet){
				var studentprofileprogressweightdashlet=portlet.up('studentprofileprogressweightdashlet');
				studentprofileprogressweightdashlet.removeGridViewButton(studentprofileprogressweightdashlet);
				//studentprofileprogressweightdashlet.removeExportToPng();
			}
		}
	},{

		//model:'Academia.model.student.studentprofile.StudentProgressReportModel',
		fields :['mnthYear', 'studentWeight', 'classAvgWeight', 'ageAvgWeight'],
		url : SERVERURL.STUDENT_WEIGHT_GRAPH_DASHLET,
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('MONTHYEAR'),
			dataIndex: 'mnthYear',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('STUDENTWEIGHT'),
			dataIndex : 'studentWeight',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('CLASSAVG'),
			dataIndex : 'classAvgWeight',
			sortable : true,
			flex:0.2
		},  {
			text : getCommonTranslation('AGEAVG'),
			dataIndex: 'ageAvgWeight',
			sortable : true,
			flex:0.2
		}],
		listeners:{
			activate:function(portlet){
				var studentprofileprogressweightdashlet=portlet.up('studentprofileprogressweightdashlet');
				//studentprofileprogressweightdashlet.addExportToPdf(studentprofileprogressweightdashlet);
				studentprofileprogressweightdashlet.activeTab = 0;
				studentprofileprogressweightdashlet.addGraphViewButton(studentprofileprogressweightdashlet);
				//studentprofileprogressweightdashlet.addExportToPdf(studentprofileprogressweightdashlet,portlet);
				//studentprofileprogressweightdashlet.addExportToExcel(studentprofileprogressweightdashlet,portlet);
				portlet.doLayout();
			},
			deactivate:function(portlet){
				var studentprofileprogressweightdashlet=portlet.up('studentprofileprogressweightdashlet');
				studentprofileprogressweightdashlet.removeGraphViewButton(studentprofileprogressweightdashlet);
				//studentprofileprogressweightdashlet.removeExportToPdf();
				//studentprofileprogressweightdashlet.removeExportToExcel();
			}
		}
	},{
		xtype: 'panel',
		width: '100%',
		height: '100%',
		html: '<div><div class ="dashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
		style:{
		    left: '-12%;'
		},
		listeners:{
			activate:function(portlet){
				var studentprofileprogressweightdashlet=portlet.up('studentprofileprogressweightdashlet');
				//studentprofileprogressweightdashlet.addExportToPdf(studentprofileprogressweightdashlet);
				studentprofileprogressweightdashlet.activeTab = 1;
				studentprofileprogressweightdashlet.addGraphViewButton(studentprofileprogressweightdashlet);
				//studentprofileprogressweightdashlet.addExportToPdf(studentprofileprogressweightdashlet,portlet);
				//studentprofileprogressweightdashlet.addExportToExcel(studentprofileprogressweightdashlet,portlet);
			},
			deactivate:function(portlet){
				var studentprofileprogressweightdashlet=portlet.up('studentprofileprogressweightdashlet');
				studentprofileprogressweightdashlet.removeGraphViewButton(studentprofileprogressweightdashlet);
				//studentprofileprogressweightdashlet.removeExportToPdf();
				//studentprofileprogressweightdashlet.removeExportToExcel();
			}
		}
	}]
});
