/**
 * @author Abhishek Chouhan

 * This component is used for to show StaffCalendar Grid
 */
Ext.define('Academia.view.personinfo.faculty.StaffWorkHoursGrid',
		{
	extend : 'Ext.grid.Panel',
	alias : 'widget.staffworkhoursgrid',
	//store : 'calendar.StaffCalendarByIdStore',
	title: getPersonModuleTranslation('WORK_HOURS'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.callParent(arguments);
    },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph:  ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}],
	columns : [{
		header : getCommonTranslation('CALENDAR'),	
		dataIndex : 'calendarName',
		align: 'center',
		sortable : true,	
		flex : .2,
		renderer:function(record){
			if(!isNullOrEmpty(record)){
				return "<a href='#'>"+record+"</a>";
			}else{
				return "-";
			}
			
		} 
	}, {
		header : getCommonTranslation('START_DATE'),
		dataIndex : 'startDate',
		align: 'center',
		sortable : true,	
		flex : .4,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getCommonTranslation('END_DATE'),
		dataIndex : 'endDate',
		align: 'center',
		sortable : true,	
		flex : .4,
		renderer:function(date) {
			return dateRender(date);
		}
	}],
    buildStore: function() {
        return Ext.create('Academia.store.calendar.StaffCalendarByIdStore');
    }

	/*dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'calendar.StaffCalendarByIdStore',
			emptyMsg : "No Record to display",
			displayInfo : true
		} ]
	} ]*/
});
