/**
 * @author Pankaj Sisodiya
 */
Ext.define('Academia.view.personinfo.student.StudentPostGraduationUploadform', {
	extend: 'Ext.form.Panel',
	alias: 'widget.studentPostGraduationUploadform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
defaults: {
		width: 226,
		labelAlign: 'top'
	},
	items: [{
		xtype:'uploadoptionradiogroup',
		width: 300,
        margin: 0,
		itemId:'stdPostGraduationUploadRadioGroupItemId',
	},{
		xtype:'fieldcontainer',
		layout : 'hbox',
		width:'100%',
		defaults: {
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'importPostGraduationId',
			width : 226,
			itemId:'importPostGraduationId',
			store:Ext.create('Ext.data.Store', {
				fields: ['id', 'value'],
				data : [
					{"id":"IMPORT_FUNCTIONARY_DETAILS", "value":getCommonTranslation('IMPORT_FUNCTIONARY_DETAILS')},
					{"id":"IMPORT_EXAMINER_DETAILS", "value":getCommonTranslation('IMPORT_EXAMINER_DETAILS')}
					]
			}),
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			value:'IMPORT_FUNCTIONARY_DETAILS',
			allowBlank:false
		},{
			xtype: 'customcombobox',
			name: 'importUtilityMasterId',
			itemId:'moduleNamePostGradutaion',
			store:'importutility.ModuleName',
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			width : 226,
			forceSelection:true,
			allowBlank:false
		}]
	},{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 460,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadFilePostGraduationId',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'stdPostGraduation',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtnPost',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
