/**
 * Student Profile
 */
Ext.define('Academia.view.personinfo.student.StudentProfile', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.studentprofile',
	cls: 'panelNoSpace',
	width: '100%',
	personId: '',
	personObj: {},
	style:{
		'top':'-12.5px !important'
	},
	defaults: {
		autoScroll: true
	},
	layout: {
		type: 'border'
	},
	initComponent: function() {

		this.items = [{
			xtype: 'panel',
			region: 'center',
			cls: 'panelNoSpace',
			autoScroll: true,
			layout: {
				type: 'vbox'
			},
			items: [{
				/*xtype: 'panel',
				layout: {
					type: 'hbox'
				},
				width: '100%',*/
				//minWidth: 500,
				/*items: [ {
		                xtype: 'panel',
		                style: {
		                    marginTop: '0px !important'
		                },
		                width: '20%',
		                items: [{
			            	xtype:'image',
			                itemId: 'profile_image',
			                border: 1,
			                style: {
			                    borderColor: 'black',
			                    borderStyle: 'solid'
			                },
			                width: 130,
			                height: 150
			            }]
				},{*/
				/* xtype: 'panel',
		                cls: 'panelNoSpace',
		                style: {
		                	marginLeft: '-10px !important',
		                    marginTop: '0px !important'
		                },
		                width: '50%',
		                items: [this.getStudentProfileView()]*/
				/*},{
		            	xtype:'panel',
		            	cls: 'panelNoSpace',
		            	 width: '30%',
		                style: {
		                	marginLeft: '-10px !important',
		                    marginTop: '0px !important'
		                },
		                items:[{
    		            	xtype:'customcombobox',
    		            	labelAlign:'top',
    		            	style:{
    		            		marginTop: '-10px'
    		            	}
    		            }]
		            }]*/
				//},{
				
					xtype: 'panel',
					//height:145,
					layout: {
						type: 'hbox'
					},
					style:{
					'border':'1px solid #e0e0e0;',
					'marginTop':'30px !Important',
					'border-radius': '5px;',
					'box-sizing': 'border-box',
					'box-shadow': '0px 2px 10px rgba(0, 0, 0, 0.1)',
					'border-radius': '4px'
					},
					width: '100%',
					//minWidth: 500,
					items: [ {
						xtype: 'panel',
						style: {
							marginTop: '0px !important'
						},
						layout: {
							type: 'hbox'
						},
						width: '100%',
						items: [{
							xtype:'image',
							itemId: 'profile_image',
							border: 1,
							style: {
								borderColor: '#e0e0e0',
								borderStyle: 'solid',
								borderRadius:'50%',
								marginTop: '25px !important',
								marginLeft: '13px !important'
							},
							width: 64,
							height: 64

						},{
						    xtype: 'container', // Using container to manage custom HTML
						    itemId: 'profile_image_icon',
						    style: {
						        marginTop: '25px',
						        marginLeft: '13px'
						    },
						    html: '<span class="hoverElement" style="display: inline-block; width: 25px; height: 25px; border: 1px solid #e0e0e0; border-radius: 50%; overflow: hidden; padding: 5px; position: absolute; left: -32px; background-color: #fff; top: 35px;">' +
						          '<img class="hoverImage" src="resources/images/Edit_Pro.svg" style="width: 100%; height: 100%; object-fit: cover;">' +
						          '</span>'
						},{
							xtype: 'panel',
							flex: 1,
							style: {
								marginTop: '25px !important',
								marginLeft: '8px !important',
							},
							//width: '80%',
							//height:100,
							items: [this.getStudentProfileView()]
						}]
					}]
				
			}, {
				xtype: 'personinfopanel',
				itemId:'studentPersonalInfoPanel',
				minWidth: 800,
				defaults: {
					border: false
				},
				listeners:{
					tabchange:function(tabpanel,newTab,oldTab){
						var grid = tabpanel.getActiveTab().down('grid');
						if(!isNullOrEmpty(grid)){
					//	grid.el.dom.style.opacity=0;
							var structure = tabpanel.up('studentprofile');
							var bodyScrollStructure = structure.down('[region=center]');
							if(!isNullOrEmpty(bodyScrollStructure.body)){
								bodyScrollStructure.body.scrollBy(0,1);
								bodyScrollStructure.body.scrollBy(0,-1);
								grid.el.dom.style.opacity=1;
							}
						}
					}
						
				}
			}]
		}, {
			xtype:'panel',
			width: '20%',
			region: 'east',
			layout:'vbox',
			cls: 'panelNoSpace',
			itemId: 'studentProfileEastPanel',
			collapsible: true,
			border: true,
			defaults: {
				bodyStyle: 'padding:5px'
			},
			header:{
				layout:
			    {
			        type: 'hbox',
			        pack: 'end'
			    },
				items:[
					{
			        	xtype: 'combo',
			        	itemId: 'personalDetailLinkSearchComboBox',
			        	cls: 'searchComboBoxCls est_combo_cls',
			            store: Ext.create('Academia.view.personinfo.common.PersonDetailsLinkSearchStore'),
			            displayField: 'searchText',
			            valueField: 'menuId',
			            hideLabel: true,
			            width:'85%',
			            hideTrigger:true,
			        	enableKeyEvents: true,
			        	allowCollapse: false,
			        	minChars: 0,
			        	queryMode: 'local',
			        	emptyCls: 'search-empty-text-field',
			        	style: 'left:0 !important; top: 0 !important;',
			        	emptyText: getCommonTranslation('SEARCH'),
			        	anyMatch:    true,
			            listConfig: {
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_MATCH'),
			                cls: 'searchMenuListCls',
			                getInnerTpl: function() {
			                    return '<a class="searchItemCls">' +
			                        '<span class="displayPathCls" style="margin-left: 10px;">{displayPath}</span><span class="titleCls" style="left: 10px;">{title}</span>' +
			                    '</a>';
			                }
			            },
			            listeners: {
			            	select: function(combo, record){
			            		var parentPanelSelector = record[0].get('parentPanelSelector'),
			            			currentElementSelector = record[0].get('currentElementSelector'),
			            			currentItemIndex = record[0].get('currentItemIndex');
			            		
			            		Ext.getCmp(parentPanelSelector).up().expand();
			            		if(Ext.query('#'+parentPanelSelector)[0].querySelectorAll(currentElementSelector).length == 0) {
			            			setTimeout(function(){
			            				Ext.query('#'+parentPanelSelector)[0].querySelectorAll(currentElementSelector)[currentItemIndex].click();
			            			},500);
			            		}
			            		else {
				            		Ext.query('#'+parentPanelSelector)[0].querySelectorAll(currentElementSelector)[currentItemIndex].click();
			            		}
			            		combo.clearValue();
			            	},
			            	beforequery: function(record){  //Added for sorting & any match
			            		this.getStore().sort([{
			                    	property : 'title',
			                    	direction: 'ASC'
			                    }]);
			                }
			            }
			        }
				]
			},
			hideHeaders : false,
			animate : true,
			animCollapse: true,
			titleCollapse : true,
			items:[/*{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'vbox',
					align: 'center',
					pack: 'center'
				},
				items:[{
					xtype:'image',
					itemId: 'profile_image',
					border: 1,
					style: {
						borderColor: 'black',
						borderStyle: 'solid'
					},
					width: 130,
					height: 150
				}]
			},{
				xtype: 'fieldcontainer',
				width:'100%',
				defaults: {
					autoScroll: true
				},
				items:[
					this.getStudentProfileView()
					]
			},*/{
				xtype: 'persondetailslinkpanel',
				flex: 1,
				collapsible: false,
				width:'100%',
				itemId : 'studentPersonDetailsLinkPanel',
				border:false,
				cls: 'panelNoSpace'
			}]
		}];

		this.callParent(arguments);
	},
	getStudentProfileView: function() {
		var studentProfile = new Ext.XTemplate('<tpl for="."><div>', 
				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%;table-layout: fixed;">', 
				 '<tr style = "line-height: 28px;">',
                 '<th style ="font-weight: 700;width:14%;text-align: left;">'+ getCommonTranslation('STUDENT_CARD_ID') +'</th>',
                 '<th style ="font-weight: 700;width:19%;text-align: left;">'+ getCommonTranslation('STUDENT_CARD_NAME') +'</th>',
                 '<th style ="font-weight: 700;width:16%;text-align: left;">'+ getCommonTranslation('STUDENT_CARD_MOB_NO') +'</th>',
                 '<th style ="font-weight: 700;width:32%;text-align: left;">'+ getCommonTranslation('STUDENT_CARD_EMAIL_ID') +'</th>',
                 '<th style ="font-weight: 700;width:10%;text-align: left;">'+ getCommonTranslation('STUDENT_CARD_STATUS') +'</th>',
                 '<th style ="font-weight: 700;width:9%;text-align: left;">'+ getCommonTranslation('Student_hold') +'</th>',
               '</tr>',
               '<tr>', 
				'<td style ="text-align: left;width:20%;">','<div>',
				'<span style="word-wrap: break-word;">{personId}</span></div></td>',
				
				'<td style ="text-align: left;width:20%;">','<div>',
				'<img src="resources/images/student_profileIcon_trans.svg" style="width:16px;height:19px;position: absolute;">',
               
				'<span style ="margin-left: 21px;font-weight: 400;">{printName}</span></div></td>', 
				'<td style ="text-align: left;width:20%;">','<div>',
				'<img src="resources/images/call_Icon_trans.svg" style="width:16px;height:19px;position: absolute;">',
				/*'<span style ="margin-left: 25px;font-weight: 600;">',
				'<tpl if="phoneCountryCode != null">{phoneCountryCode}-</tpl>',
				'{phoneNo}</span>',*/
				'<span style ="font-weight: 400;margin-left: 21px;"><tpl if="mobileCountryCode != null">{mobileCountryCode}-</tpl><tpl if="mobileNumber != null">{mobileNumber}</tpl></span></div></td>',
				'<td style ="text-align: left;width:20%;">','<div>',
				'<img src="resources/images/email_Icon_trans.svg" style="width:16px;height:19px;position: absolute;">',
//				'<img src="resources/images/email_Icon_trans.svg" style="width:16px;height:19px;position: relative;">',
				'<span style ="margin-left: 21px;font-weight: 400;word-wrap: break-word;">{emailId}</span></div></td>',
				'<tpl if="this.isActive(status)">',
				'<td <span style="color:#12bc34; margin-left : 7px; font-size : 13px"><strong>Active</strong></span></td>',
				'<tpl else>',
				'<td <span style="color:#de5a63; margin-left : 7px; font-size : 13px"><strong>Inactive</strong></span></td>', 
				'</tpl>',
				
				
				'<td style="text-align: left; width:20%; padding-right:6px;">',
				'<a href="#" class="hold-alert-link" style="text-decoration: underline; color: blue;">',
				'<span style="font-weight: 400;">{activeHoldsCount}</span>',
				'</a>',
				'</td>',
			
				/*'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', hello
				'<tr>', 
				'<td style="width:50%;vertical-align:top;">', 
				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
				'<tr>', 
				'<td align="center"><span>{firstName} {middleName} {lastName}</span></td>', 
				'</tr>', 
				'<tr>', 
				'<td align="center"><span>',
				'<tpl if="phoneCountryCode != null">{phoneCountryCode}-</tpl><tpl if="phoneAreaCode != null">{phoneAreaCode}-</tpl>',
				'{phoneNo}</span> </td>',  
				'</tr>', 
				'<tr>', 
				'<td align="center"><span>',
				'<tpl if="mobileCountryCode != null">{mobileCountryCode}-</tpl><tpl if="mobileNumber != null">{mobileNumber}</tpl>',
				'</span> </td>', 
				'</tr>', 
				'<tr>',
				'<td align="center"><span>{emailId}</span></td>',
				'</tr>', 

				'<tr>',
				'<td align="center"><span>',
				'<tpl if="status == \'Active\'"> <span style ="font-weight:bold;"> '+' {status} </span></tpl>', 
				'<tpl if="status == \'Inactive\'"> <span style ="font-weight:bold;"> ' + ' {status} </span></tpl></td>', 
				'</tr>', 

				'<tr>', 
				'<td align="center"><tpl if="isMidtermJoinee == true">' + getPersonModuleTranslation("MID_TERM_JOINEE") + '</tpl></td>', 
				'</tr>', 
				'</table>', 
				'</td>', */

				/*
				 * Hide template for other info in student detail By nilesh sir.
				 * 
				 * '<td>', 
        				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('NO_OF_PENDING_BILLS') + ':{noOfPendingBills}</td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('TOTAL_PENDING_AMOUNT') + ':{totalPendingAmount} </td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('NO_OF_PDC_DUE_FOR_SUBMISSION') + ':{noOfPDCDue} </td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('PENDING_DOCUMENTS') + ':{pendingDocument} </td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('REQUEST_PENDING_DECISION') + ':{requestPendingDescision} </td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('SMS_FAILURE') + ':{smsFailure} </td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>' + getPersonModuleTranslation('EMAIL_FAILURE') + ':{emailFailure} </td>', 
        					'</tr>', 
        				'</table>', 
        			'</td>',*/ 
				'</tr>', 
		'</table></div>',
				'<tpl if="isInvalidDocument == true">',
		        '<td>',
		            '<p style="font-weight: 700;color: #ff0000;"><b style="font-weight: 700;color: #666666;">' + getCommonTranslation('APPLICANT_DOCUMENT_REMARK') + ' : </b>' + getCommonTranslation('APPLICANT_DOCUMENT_INVALID_MESSAGE') + '</p>',
		        '</td>',
		        '</tpl>',
				'</tpl>',
				
				{
					isActive: function(status){
						return status=="Active";
					},
					/*isInvalidDoc: function(isInvalidDocument){
						return isInvalidDocument == "true";
					}*/
				}
		);
		
		

		var studentProfileView={
				xtype: 'dataview',
				alias: 'widget.studentprofileview',
				itemId: 'studentProfileView',
				width: '100%',
				store: Ext.create('Academia.store.personinfo.student.StudentProfileStore'),
				tpl: studentProfile,
				itemSelector: 'div.thumb-wrap'
		};

		return studentProfileView;
	},

	getStudentPerformanceView: function() {

		var studentPerformanaceSnapshot = new Ext.XTemplate('<tpl><div class="thumb-wrap">', 
				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
				'<tr>', 
				'<td style="width:30%">', 
				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
				'<tr>', 
				'<td> ' + getPersonModuleTranslation('CUMULATIVE_MARKS_GRADES') + ': </td>', 
				'</tr>', 
				'<tr>', 
				'<td>' + getPersonModuleTranslation('CURRENT_RANKS') + ':  </td>', 
				'</tr>', 
				'<tr>', 
				'<td>' + getPersonModuleTranslation('PROGRAM_RANK') + ':  </td>', 
				'</tr>', 
				'</table>', 
				'</td>', 
				'<td style="width:30%">', 
				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
				'<tr>', 
				'<td> ' + getPersonModuleTranslation('DEFICIT_CREDIT') + ': </td>', 
				'</tr>', 
				'<tr>', 
				'<td>' + getPersonModuleTranslation('CREDIT_COMPLETED') + ': </td>', 
				'</tr>', 
				'<tr>', 
				'<td>' + getPersonModuleTranslation('CREDIT_REQUIRED_COMPLETED') + ':  </td>', 
				'</tr>', '</table>', '</td>', '<td>', '<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
				'<tr>', 
				'<td> ' + getPersonModuleTranslation('DEFICIT_COURSES') + ': </td>', 
				'</tr>', 
				'<tr>', 
				'<td>' + getPersonModuleTranslation('COURSE_COMPLETED') + ':  </td>', 
				'</tr>', 
				'<tr>', 
				'<td>' + getPersonModuleTranslation('COURSES_REQUIRED_COMPLETED') + ':  </td>', 
				'</tr>', 
				'</table>', 
				'</td>', 
				'</tr>', 
		'</table></div></tpl>');
		var StudentPerformanceView = Ext.define('Academia.view.personinfo.student.StudentPerformanceView', {
			extend: 'Ext.view.View',
			margin: '0px',
			alias: 'widget.studentperformanceview',
			tpl: studentPerformanaceSnapshot,
			itemSelector: 'div.thumb-wrap'
		});

		return StudentPerformanceView;
	}
});
