/**
 * @author Priyanshi Sharma
 * 
 */
Ext.define('Academia.view.personinfo.student.StudentStatusDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentstatusdownloadform',
	plugins : "formlabelrequired",
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype:'fieldcontainer',
		width: '100%',
		itemId:'programBatchContainerId',
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				xtype: 'customcombobox',
                name: 'programName',
                itemId: 'programItemId',
                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
                valueField: 'id',
                displayField: 'valueCode',
                width:410,
                minChars:3,
                queryParam:'programName',
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
                allowBlank: false,
    			typeAhead:false,
                listeners: {
                    render: function(combo) {
                    	var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
                        combo.bindStore(store);
                    }
                },
                listConfig: {
	 				listeners: {
						beforeshow: function(picker) {
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					},
	 				loadingText: getCommonTranslation('SEARCHING'),
	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 				getInnerTpl: function() {
	 					return '<div class="search-item">' +
	 					 '{code} / {value}'+ 
	 					'</div>';
	 				}
	 			}
			},{
				xtype: 'customcombobox',
                name: 'batchName',
                itemId: 'batchItemId',
                fieldLabel: getCommonTranslation('BATCH'),
                disabled:true,
                editable: false,
                queryMode: 'local',
                displayField: 'value',
                valueField: 'id',
                listConfig: {
	 				listeners: {
						beforeshow: function(picker) {
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					}
	 			},
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
                        combo.bindStore(store);
                    }
                }
			},{
				xtype: 'customcombobox',
                itemId:'periodItemId',
                disabled:true,
                editable: false,
                displayField: 'value',
                valueField: 'id',
                queryMode: 'local',
                fieldLabel: getCommonTranslation('PERIOD'),
                name: 'periodName',
                listConfig: {
	 				listeners: {
						beforeshow: function(picker) {
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					}
	 			},
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                        combo.bindStore(store);
                    }
                }
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('SECTION'),
				width: 226,
				labelAlign: 'top',
				name : 'sectionName',
				itemId : 'sectionItemId',
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
				disabled:true,
				forceSelection : true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							var combo = picker.up('combobox');
							picker.setWidth(combo.getWidth());
						}
					}
				},
				/*listeners: {
				render: function(combo) {
                	var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
                    combo.bindStore(store);
				}}*/
			},{
				xtype: 'button',
				itemId: 'addMoreRowBtn',
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				style:{
					marginTop:'30px'
				}
			  }]
			}]},{
				xtype:'fieldcontainer',
				layout : 'hbox',
				items:[{
					xtype: 'fieldcontainer',
					width: 'auto',
					items: [{
			           	 xtype: 'button',
			        	 text: getCommonTranslation('DOWNLOAD_TEMPLATE'),
			             itemId: 'StdStatusLoaderDownload',
			             formBind: true,
			             ui: 'CustomBtnSubmit'
			        },{
		                xtype: 'button',
		                text: getCommonTranslation('RESET'),
		                itemId: 'resetBtn',
		                buttonAlign: 'left',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
	}]}]});
