/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.placement.placementcampus.PlacementCampusGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementcampusgrid',
	store: 'placement.placementcampus.PlacementCampusGridStore',
	title: getCommonTranslation('PLACEMENT_CAMPUS_LIST'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	/*headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'placementcampustabstructure':1
		}
	},*/
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'placement.placementcampus.PlacementCampusGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getPlacementTranslation('APPLY_TO'),
		menu:[{
			text:getPlacementTranslation('ACADEMY_LOCATION'),
			itemId:'academyLocation'
		},{
			text:getPlacementTranslation('PROGRAM_PERIOD'),
			itemId:'programPeriod'
		}],
		 listeners: { click: function() { this.showMenu(); } }
	}, '->',{
        xtype: 'button',
        itemId: 'exportPlacementFollowUpReport',
       text:getCommonTranslation('EXPORT_REPORT'),
       tooltip:getCommonTranslation('EXPORT_REPORT'),
       disabled: true
    }],
	columns: [{
		header:  getCommonTranslation('PLACEMENT_CAMPUS_CODE'),
		dataIndex: 'campusCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PLACEMENT_CAMPUS_NAME'),
		dataIndex: 'campusName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PLACEMENT_TYPE'),
		dataIndex: 'placementType',
		flex:.1,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;
		}
	},{
		header:  getCommonTranslation('PLACEMENT_CAMPUS_COORDINATOR'),
		dataIndex: 'campusCoordinator',
		flex:.1,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;
		}
	},{
		header:  getCommonTranslation('PLACEMENT_START_DATE'),
		dataIndex: 'startDate',
		flex:.1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('PLACEMENT_END_DATE'),
		dataIndex: 'endDate',
		flex:.1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('PLACEMENT_ORGANIZING_ACADEMY_LOCATION'),
		dataIndex: 'organizingAcademyLocation',
		flex:.1,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;
		}
	},{
		header:  getCommonTranslation('PLACEMENT_RECRUITING_ORGANIZATION'),
		dataIndex: 'recruitingOrganizationCount',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.recruitingOrganizationCount == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:  getCommonTranslation('PLACEMENT_ACADEMIC_ORGANIZATION'),
		dataIndex: 'academicOrganizationCount',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.academicOrganizationCount == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:  getCommonTranslation('PLACEMENT_PROGRAM_PERIOD'),
		dataIndex: 'programPeriodCount',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.programPeriodCount == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:  getCommonTranslation('PLACEMENT_DOCUMENTS'),
		dataIndex: 'documentCount',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.documentCount == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:  getCommonTranslation('PLACEMENT_STATUS'),
		dataIndex: 'status',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('PLACEMENT_MOD'),
		dataIndex: 'placementMOD',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.itemValue;
			else 
				return null;
		}
	}]
});

